/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.d4rkq1l1n;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicLineParser;
import org.apache.http.params.HttpParams;

public class LicenseHttpResponse
implements CloseableHttpResponse {
    private StatusLine okStatusLine;
    private HttpEntity entity;

    public LicenseHttpResponse(HttpRequest request) {
        this.entity = this.buildEntity(request);
    }

    public StatusLine getStatusLine() {
        this.okStatusLine = BasicLineParser.parseStatusLine((String)"HTTP/1.0 200 OK", null);
        return this.okStatusLine;
    }

    public void setStatusLine(StatusLine arg0) {
    }

    public void setStatusLine(ProtocolVersion arg0, int arg1) {
    }

    public void setStatusLine(ProtocolVersion arg0, int arg1, String arg2) {
    }

    public void setStatusCode(int arg0) throws IllegalStateException {
    }

    public void setReasonPhrase(String arg0) throws IllegalStateException {
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setEntity(HttpEntity arg0) {
    }

    public Locale getLocale() {
        return Locale.ENGLISH;
    }

    public void setLocale(Locale l) {
    }

    public ProtocolVersion getProtocolVersion() {
        return null;
    }

    public boolean containsHeader(String arg0) {
        return false;
    }

    public Header[] getHeaders(String arg0) {
        return null;
    }

    public Header getFirstHeader(String arg0) {
        return null;
    }

    public Header getLastHeader(String arg0) {
        return null;
    }

    public Header[] getAllHeaders() {
        return null;
    }

    public void addHeader(Header arg0) {
    }

    public void addHeader(String arg0, String arg1) {
    }

    public void setHeader(Header arg0) {
    }

    public void setHeader(String arg0, String arg1) {
    }

    public void setHeaders(Header[] arg0) {
    }

    public void removeHeader(Header arg0) {
    }

    public void removeHeaders(String arg0) {
    }

    public HeaderIterator headerIterator() {
        return null;
    }

    public HeaderIterator headerIterator(String arg0) {
        return null;
    }

    public HttpParams getParams() {
        return null;
    }

    public void setParams(HttpParams arg0) {
    }

    @Override
    public void close() throws IOException {
    }

    private HttpEntity buildEntity(HttpRequest request) {
        InputStream is = null;
        try {
            String requestedPage = request.getRequestLine().getUri();
            int idx = requestedPage.lastIndexOf("/");
            String pageName = requestedPage.substring(idx + 1);
            String content = this.generateContent(request, pageName);
            StringEntity stringEntity = new StringEntity(content, "UTF-8");
            return stringEntity;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Failed to create Entity: " + ex.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(LicenseHttpResponse.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return null;
    }

    public static boolean shouldEmulateHttpRequest(String uri) {
        return uri.contains("validate.do") || uri.contains("activate.do") || uri.contains("release.do");
    }

    private String generateContent(HttpRequest request, String pageName) {
        try {
            String edition = "ULTIMATE";
            String profileId = "9920148385793847";
            String cypher = this.getRequestParameter(request, "cypher");
            if ("validate.do".equalsIgnoreCase(pageName)) {
                return this.handleValidate(cypher, edition, "OWN", profileId, "1885380178000");
            }
            if ("activate.do".equalsIgnoreCase(pageName)) {
                String signature = "302c0214216d5f5d49a0bb62207124000c384b57307402f50214159b6f983e2143a15fbc874207db858630f89f7c";
                StringBuilder sb = new StringBuilder();
                sb.append("<?xml version=\"1.0\"?>");
                sb.append("<response success=\"true\" code=\"OK\" profileId=\"").append(profileId).append("\">");
                sb.append("<message type=\"NONE\"/>");
                sb.append("<edition>").append(edition).append("</edition>");
                sb.append("<signature>").append(signature).append("</signature>");
                sb.append("</response>");
                return sb.toString();
            }
            if ("release.do".equalsIgnoreCase(pageName)) {
                return "<?xml version=\"1.0\"?><response success=\"true\" code=\"OK\"><message type=\"NONE\"/></response>";
            }
            return null;
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            pw.close();
            JOptionPane.showMessageDialog(null, "*MERD*: " + sw.toString());
            return null;
        }
    }

    private String handleValidate(String cypher, String edition, String licType, String profileId, String expiration) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.print("<?xml version=\"1.0\"?>");
        out.print("<response success=\"true\" code=\"OK\" profileId=\"" + profileId + "\"  oanda=\"true\" iqfeed=\"true\" stage5=\"true\" cqg=\"true\" backFillURL=\"https://s3-us-west-2.amazonaws.com/elasticbeanstalk-us-west-2-200256718728/\">");
        out.print("  <support expires=\"" + expiration + "\" expired=\"false\">true</support>");
        out.print("  <edition>ULTIMATE</edition>");
        out.print("  <licenseType>" + licType + "</licenseType>");
        out.print("  <email>d4rkq1l1n@gmail.com</email>");
        out.print("  <name>D4RKQ1L1N</name>");
        out.print("  <signature>302c0214216d5f5d49a0bb62207124000c384b57307402f50214159b6f983e2143a15fbc874207db858630f89f7c</signature>");
        out.print("  <id>5044393462577767646D567963326C76626A30694D533477496A382B44516F38636D567A63473975633255676333566A5932567A637A306964484A315A5349675932396B5A543069543073694943596D49474E7959574E725A575167596E6B675A44527961334578624446755067304B504339795A584E776232357A5A54343D</id>");
        out.print("\t <cqg enabled=\"true\">");
        out.print("\t\t\t<trialTitle/>");
        out.print("\t\t\t<trialMsg/>");
        out.print("\t\t\t<warningTitle/>");
        out.print("\t\t\t<warningMsg/>");
        out.print("\t\t\t<connectTitle/>");
        out.print("\t\t\t<connectMsg/>");
        out.print("\t </cqg>");
        out.print("</response>");
        out.flush();
        out.close();
        return sw.toString();
    }

    private String utcToString(String utcTime) {
        return new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(Long.parseLong(utcTime)));
    }

    public static void main(String[] args) {
    }

    private String getRequestParameter(HttpRequest request, String paramName) throws IOException {
        String retVal = "";
        if (request instanceof HttpPost) {
            HttpPost post = (HttpPost)request;
            List<NameValuePair> params = URLEncodedUtils.parse(post.getEntity());
            for (NameValuePair p : params) {
                if (!paramName.equalsIgnoreCase(p.getName())) continue;
                retVal = p.getValue();
                break;
            }
        } else {
            JOptionPane.showMessageDialog(null, "*NON* POST: " + request.getClass().getCanonicalName());
        }
        return retVal;
    }
}

