/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.config.Lookup;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.client.InternalHttpClientOrig;
import org.apache.http.impl.client.d4rkq1l1n.LicenseHttpResponse;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.HttpContext;

class InternalHttpClient
extends InternalHttpClientOrig {
    public InternalHttpClient(ClientExecChain execChain, HttpClientConnectionManager connManager, HttpRoutePlanner routePlanner, Lookup cookieSpecRegistry, Lookup authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(execChain, connManager, routePlanner, (Lookup<CookieSpecProvider>)cookieSpecRegistry, (Lookup<AuthSchemeProvider>)authSchemeRegistry, cookieStore, credentialsProvider, defaultConfig, closeables);
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        String uri = request.getRequestLine().getUri();
        if (LicenseHttpResponse.shouldEmulateHttpRequest(uri)) {
            return new LicenseHttpResponse(request);
        }
        return super.doExecute(target, request, context);
    }
}

