/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import com.motivewave.common.Enums$Text$Align;
import com.motivewave.common.Enums$Text$Outline;
import com.motivewave.common.h;
import i.c;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javafx.scene.paint.Color;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject$Null;
import org.json.JSONString;
import org.json.JSONTokener;

public class JSONObject {
    private Map map = new HashMap(1);
    public static final Object NULL = new JSONObject$Null(null);

    public static JSONObject parse(String string) {
        if (h.g(string)) {
            return new JSONObject();
        }
        try {
            return new JSONObject(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new JSONObject();
        }
    }

    public static boolean isJSON(String string) {
        if (h.g(string)) {
            return true;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            return c2 == '{' || c2 == '[';
        }
        return false;
    }

    public JSONObject() {
    }

    public JSONObject(JSONObject jSONObject, String[] stringArray) {
        this();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                this.putOnce(stringArray[i2], jSONObject.opt(stringArray[i2]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(JSONTokener jSONTokener) {
        this();
        if (jSONTokener.nextClean() != '{') {
            throw jSONTokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c2 = jSONTokener.nextClean();
            switch (c2) {
                case '\u0000': {
                    throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jSONTokener.back();
            String string = jSONTokener.nextValue().toString();
            c2 = jSONTokener.nextClean();
            if (c2 == '=') {
                if (jSONTokener.next() != '>') {
                    jSONTokener.back();
                }
            } else if (c2 != ':') {
                throw jSONTokener.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(string, jSONTokener.nextValue());
            switch (jSONTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == '}') {
                        return;
                    }
                    jSONTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(String string) {
        this(new JSONTokener(string));
    }

    public String getString(String string) {
        return this.str(string);
    }

    public Object get(String string) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return null;
        }
        return object;
    }

    public JSONObject accumulate(String string, Object object) {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, object instanceof JSONArray ? new JSONArray().put(object) : object);
        } else if (object2 instanceof JSONArray) {
            ((JSONArray)object2).put(object);
        } else {
            this.put(string, new JSONArray().put(object2).put(object));
        }
        return this;
    }

    public JSONObject append(String string, Object object) {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, new JSONArray().put(object));
        } else if (object2 instanceof JSONArray) {
            this.put(string, ((JSONArray)object2).put(object));
        } else {
            throw new JSONException("JSONObject[" + string + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return "null";
        }
        String string = Double.toString(d2);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public boolean is(String string) {
        return this.is(string, true);
    }

    public boolean is(String string, boolean bl2) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return bl2;
        }
        return h.a(v2);
    }

    public Boolean getBoolean(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return null;
        }
        return h.a(v2);
    }

    public Double getDoubleObj(String string) {
        return this.has(string) ? Double.valueOf(this.getDouble(string, 0.0)) : null;
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d2) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return d2;
        }
        return h.a(v2);
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f2) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return f2;
        }
        return h.a(v2);
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public int getInt(String string, int n2) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return n2;
        }
        return h.a(v2);
    }

    public Integer getInteger(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return null;
        }
        return h.a(v2);
    }

    public JSONArray getJSONArray(String string) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return null;
        }
        try {
            return (JSONArray)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List getStringList(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return Collections.EMPTY_LIST;
        }
        try {
            JSONArray jSONArray = (JSONArray)v2;
            List list = h.b(new String[0]);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                list.add(jSONArray.getString(i2));
            }
            return list;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List getList(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return Collections.EMPTY_LIST;
        }
        try {
            JSONArray jSONArray = (JSONArray)v2;
            List list = h.b(new Object[0]);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                list.add(jSONArray.get(i2));
            }
            return list;
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST;
        }
    }

    public List getObjList(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return Collections.EMPTY_LIST;
        }
        try {
            JSONArray jSONArray = (JSONArray)v2;
            List list = h.b(new JSONObject[0]);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                list.add(jSONArray.getJSONObject(i2));
            }
            return list;
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST;
        }
    }

    public JSONObject obj(String string) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return null;
        }
        try {
            return (JSONObject)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean exists(String string) {
        Object object = this.opt(string);
        return !this.isNullValue(object);
    }

    public long getLong(String string) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return 0L;
        }
        return h.a(object);
    }

    public long getLong(String string, long l2) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return l2;
        }
        return h.a(object);
    }

    public static String[] getNames(JSONObject jSONObject) {
        int n2 = jSONObject.length();
        if (n2 == 0) {
            return null;
        }
        Iterator iterator = jSONObject.keys();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (iterator.hasNext()) {
            stringArray[n3] = (String)iterator.next();
            ++n3;
        }
        return stringArray;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        int n2 = fieldArray.length;
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = fieldArray[i2].getName();
        }
        return stringArray;
    }

    public String str(String string) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return null;
        }
        return object.toString();
    }

    public String str(String string, String string2) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return string2;
        }
        return object.toString();
    }

    public File getFile(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        return new File(string2);
    }

    public Color getColorFX(String string) {
        return h.a(this.getColor(string));
    }

    public Color getColorFX(String string, Color color) {
        return h.a(this.getColor(string, h.a(color)));
    }

    public java.awt.Color getColor(String string) {
        return this.getColor(string, null);
    }

    public java.awt.Color getColor(String string, java.awt.Color color) {
        return this.readColor(this.str(string), color);
    }

    public Locale getLocale(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, '|');
        if (list.size() != 3) {
            return null;
        }
        return new Locale((String)list.get(0), (String)list.get(1), (String)list.get(2));
    }

    private java.awt.Color readColor(String string, java.awt.Color color) {
        if (h.g(string)) {
            return color;
        }
        List list = h.a(string, ',');
        if (list == null || list.size() < 3 || list.size() > 4) {
            return color;
        }
        if (list.size() == 4) {
            return new java.awt.Color(h.b((String)list.get(0)), h.b((String)list.get(1)), h.b((String)list.get(2)), h.b((String)list.get(3)));
        }
        return new java.awt.Color(h.b((String)list.get(0)), h.b((String)list.get(1)), h.b((String)list.get(2)));
    }

    public List getColors(String string) {
        List list = this.getStringList(string);
        if (h.a((Collection)list)) {
            return new ArrayList();
        }
        ArrayList<java.awt.Color> arrayList = new ArrayList<java.awt.Color>();
        for (String string2 : list) {
            java.awt.Color color = this.readColor(string2, null);
            if (color == null) continue;
            arrayList.add(color);
        }
        return arrayList;
    }

    public List getFXColors(String string) {
        List list = this.getStringList(string);
        if (h.a((Collection)list)) {
            return new ArrayList();
        }
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (String string2 : list) {
            java.awt.Color color = this.readColor(string2, null);
            if (color == null) continue;
            arrayList.add(h.a(color));
        }
        return arrayList;
    }

    public BasicStroke getStroke(String string) {
        JSONObject jSONObject = this.obj(string);
        if (jSONObject == null) {
            return null;
        }
        float f2 = jSONObject.getFloat("width", 1.0f);
        float[] fArray = this.getDash("dash");
        if (fArray != null) {
            return new BasicStroke(f2, 1, 0, 1.0f, fArray, 0.0f);
        }
        return new BasicStroke(f2);
    }

    public Enums$Text$Align getTextAlign(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        try {
            return Enums$Text$Align.valueOf(string2);
        }
        catch (Exception exception) {
            return Enums$Text$Align.LEFT;
        }
    }

    public Enums$Text$Align getTextAlign(String string, Enums$Text$Align enums$Text$Align) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return enums$Text$Align;
        }
        try {
            return Enums$Text$Align.valueOf(string2);
        }
        catch (Exception exception) {
            return enums$Text$Align;
        }
    }

    public Enums$Text$Outline getTextOutline(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        try {
            return Enums$Text$Outline.valueOf(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public javafx.scene.text.Font getFontFX(String string) {
        return c.a(this.getFont(string));
    }

    public javafx.scene.text.Font getFontFX(String string, javafx.scene.text.Font font) {
        Font font2 = this.getFont(string);
        return font2 == null ? font : c.a(font2);
    }

    public Font getFont(String string) {
        return this.getFont(string, null);
    }

    public Font getFont(String string, Font font) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return font;
        }
        List list = h.a(string2, '|');
        if (h.a((Collection)list) || list.size() < 2) {
            return font;
        }
        String string3 = (String)list.get(0);
        float f2 = h.b((String)list.get(1));
        String string4 = list.size() > 2 ? (String)list.get(2) : "";
        int n2 = 0;
        if (!h.g(string4)) {
            if (string4.indexOf("B") != -1) {
                n2 |= 1;
            }
            if (string4.indexOf("I") != -1) {
                n2 |= 2;
            }
        }
        Font font2 = new Font(string3, n2, (int)f2);
        font2 = font2.deriveFont(f2);
        if (string4 != null && string4.indexOf("U") != -1) {
            font2 = h.a(font2, true);
        }
        return font2;
    }

    public Point2D getPoint(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (list.size() != 2) {
            return null;
        }
        return new Point2D.Double(h.a((String)list.get(0)), h.a((String)list.get(1)));
    }

    public double[] getDoubleArray(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (h.a((Collection)list)) {
            return null;
        }
        double[] dArray = new double[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            dArray[i2] = h.a((String)list.get(i2));
        }
        return dArray;
    }

    public boolean[] getBooleanArray(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (h.a((Collection)list)) {
            return null;
        }
        boolean[] blArray = new boolean[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            blArray[i2] = h.a(list.get(i2));
        }
        return blArray;
    }

    public float[] getDash(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (h.a((Collection)list)) {
            return null;
        }
        float[] fArray = new float[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            fArray[i2] = h.b((String)list.get(i2));
        }
        return fArray;
    }

    public Insets getInsets(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (h.a((Collection)list) || list.size() != 4) {
            return null;
        }
        return new Insets(h.b((String)list.get(0)), h.b((String)list.get(1)), h.b((String)list.get(2)), h.b((String)list.get(3)));
    }

    public boolean has(String string) {
        return this.map.containsKey(string);
    }

    public boolean isNull(String string) {
        Object object = this.opt(string);
        return object == null || NULL.equals(object);
    }

    public boolean isEmpty(String string) {
        Object object = this.opt(string);
        if (object == null || NULL.equals(object)) {
            return true;
        }
        if (object instanceof JSONArray) {
            return ((JSONArray)object).isEmpty();
        }
        return h.b(object);
    }

    boolean isNullValue(Object object) {
        return object == null || NULL.equals(object);
    }

    public JSONArray names() {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = this.keys();
        while (iterator.hasNext()) {
            jSONArray.put(iterator.next());
        }
        return jSONArray.length() == 0 ? null : jSONArray;
    }

    public Iterator keys() {
        return this.map.keySet().iterator();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int length() {
        return this.map.size();
    }

    public static String numberToString(Number number) {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object opt(String string) {
        return string == null ? null : this.map.get(string);
    }

    public JSONObject put(String string, boolean bl2) {
        this.map.put(string, bl2);
        return this;
    }

    public JSONObject put(String string, Collection collection) {
        if (collection == null) {
            this.map.put(string, null);
        } else {
            this.map.put(string, new JSONArray(collection));
        }
        return this;
    }

    public JSONObject put(String string, double d2) {
        this.map.put(string, d2);
        return this;
    }

    public JSONObject put(String string, float f2) {
        this.map.put(string, Float.valueOf(f2));
        return this;
    }

    public JSONObject put(String string, int n2) {
        this.map.put(string, n2);
        return this;
    }

    public JSONObject put(String string, long l2) {
        this.map.put(string, l2);
        return this;
    }

    public JSONObject put(String string, Object object) {
        if (object != null) {
            this.map.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    public JSONObject putOnce(String string, Object object) {
        if (string != null && object != null) {
            if (this.opt(string) != null) {
                throw new JSONException("Duplicate key \"" + string + "\"");
            }
            this.put(string, object);
        }
        return this;
    }

    public JSONObject putOpt(String string, Object object) {
        if (string != null && object != null) {
            this.put(string, object);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c2 = '\u0000';
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 4);
        stringBuffer.append('\"');
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = c2;
            c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c2);
                    continue block9;
                }
                case '/': {
                    if (c3 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c2);
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                default: {
                    if (c2 < ' ' || c2 >= '\u0080' && c2 < '\u00a0' || c2 >= '\u2000' && c2 < '\u2100') {
                        String string2 = "000" + Integer.toHexString(c2);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4));
                        continue block9;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public Object remove(String string) {
        return this.map.remove(string);
    }

    public Iterator sortedKeys() {
        return new TreeSet(this.map.keySet()).iterator();
    }

    public static Object stringToValue(String string) {
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("null")) {
            return NULL;
        }
        char c2 = string.charAt(0);
        if (c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-' || c2 == '+') {
            if (c2 == '0' && string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                try {
                    return Integer.parseInt(string.substring(2), 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    return Double.valueOf(string);
                }
                Long l2 = Long.valueOf(string);
                if (l2 == (long)l2.intValue()) {
                    return l2.intValue();
                }
                return l2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    static void testValidity(Object object) {
        if (object != null && (object instanceof Double ? ((Double)object).isInfinite() || ((Double)object).isNaN() : object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        JSONArray jSONArray2 = new JSONArray();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            jSONArray2.put(this.opt(jSONArray.getString(i2)));
        }
        return jSONArray2;
    }

    public String toString() {
        try {
            Iterator iterator = this.keys();
            StringBuffer stringBuffer = new StringBuffer("{");
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object e2 = iterator.next();
                stringBuffer.append(JSONObject.quote(e2.toString()));
                stringBuffer.append(':');
                stringBuffer.append(JSONObject.valueToString(this.map.get(e2)));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n2) {
        return this.toString(n2, 0);
    }

    String toString(int n2, int n3) {
        int n4 = this.length();
        if (n4 == 0) {
            return "{}";
        }
        Iterator iterator = this.sortedKeys();
        StringBuffer stringBuffer = new StringBuffer("{");
        int n5 = n3 + n2;
        if (n4 == 1) {
            Object e2 = iterator.next();
            stringBuffer.append(JSONObject.quote(e2.toString()));
            stringBuffer.append(": ");
            stringBuffer.append(JSONObject.valueToString(this.map.get(e2), n2, n3));
        } else {
            int n6;
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(",\n");
                } else {
                    stringBuffer.append('\n');
                }
                for (n6 = 0; n6 < n5; ++n6) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(JSONObject.quote(e3.toString()));
                stringBuffer.append(": ");
                stringBuffer.append(JSONObject.valueToString(this.map.get(e3), n2, n5));
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append('\n');
                for (n6 = 0; n6 < n3; ++n6) {
                    stringBuffer.append(' ');
                }
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static String valueToString(Object object) {
        if (object == null || object.equals(null)) {
            return "null";
        }
        if (object instanceof JSONString) {
            String string;
            try {
                string = ((JSONString)object).toJSONString();
            }
            catch (Exception exception) {
                throw new JSONException(exception);
            }
            if (string instanceof String) {
                return string;
            }
            throw new JSONException("Bad value from toJSONString: " + string);
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean || object instanceof JSONObject || object instanceof JSONArray) {
            return object.toString();
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString();
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString();
        }
        return JSONObject.quote(object.toString());
    }

    static String valueToString(Object object, int n2, int n3) {
        if (object == null || object.equals(null)) {
            return "null";
        }
        try {
            String string;
            if (object instanceof JSONString && (string = ((JSONString)object).toJSONString()) instanceof String) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).toString(n2, n3);
        }
        if (object instanceof JSONArray) {
            return ((JSONArray)object).toString(n2, n3);
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString(n2, n3);
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString(n2, n3);
        }
        return JSONObject.quote(object.toString());
    }

    static Object wrap(Object object) {
        try {
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Writer write(Writer writer) {
        try {
            boolean bl2 = false;
            Iterator iterator = this.keys();
            writer.write(123);
            while (iterator.hasNext()) {
                if (bl2) {
                    writer.write(44);
                }
                Object e2 = iterator.next();
                writer.write(JSONObject.quote(e2.toString()));
                writer.write(58);
                Object v2 = this.map.get(e2);
                if (v2 instanceof JSONObject) {
                    ((JSONObject)v2).write(writer);
                } else if (v2 instanceof JSONArray) {
                    ((JSONArray)v2).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v2));
                }
                bl2 = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }
}

