/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation.decoration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.control.Control;
import org.controlsfx.control.decoration.StyleClassDecoration;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.decoration.AbstractValidationDecoration;

public class StyleClassValidationDecoration
extends AbstractValidationDecoration {
    private final String errorClass;
    private final String warningClass;

    public StyleClassValidationDecoration() {
        this(null, null);
    }

    public StyleClassValidationDecoration(String string, String string2) {
        this.errorClass = string != null ? string : "error";
        this.warningClass = string2 != null ? string2 : "warning";
    }

    @Override
    protected Collection createValidationDecorations(ValidationMessage validationMessage) {
        return Arrays.asList(new StyleClassDecoration(Severity.ERROR == validationMessage.getSeverity() ? this.errorClass : this.warningClass));
    }

    @Override
    protected Collection createRequiredDecorations(Control control) {
        return Collections.emptyList();
    }
}

