/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation.decoration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.scene.control.Control;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.decoration.AbstractValidationDecoration;
import org.controlsfx.validation.decoration.ValidationDecoration;

public class CompoundValidationDecoration
extends AbstractValidationDecoration {
    private final Set decorators = new HashSet();

    public CompoundValidationDecoration(Collection collection) {
        this.decorators.addAll(collection);
    }

    public CompoundValidationDecoration(ValidationDecoration ... validationDecorationArray) {
        this(Arrays.asList(validationDecorationArray));
    }

    @Override
    public void applyRequiredDecoration(Control control) {
        this.decorators.stream().forEach(validationDecoration -> validationDecoration.applyRequiredDecoration(control));
    }

    @Override
    public void applyValidationDecoration(ValidationMessage validationMessage) {
        this.decorators.stream().forEach(validationDecoration -> validationDecoration.applyValidationDecoration(validationMessage));
    }

    @Override
    protected Collection createValidationDecorations(ValidationMessage validationMessage) {
        return Collections.emptyList();
    }

    @Override
    protected Collection createRequiredDecorations(Control control) {
        return Collections.emptyList();
    }
}

