/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.tools;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Slider;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeView;
import javafx.util.Callback;
import org.controlsfx.tools.ValueExtractor$NodeValueExtractor;
import org.controlsfx.tools.ValueExtractor$ObservableValueExtractor;

public class ValueExtractor {
    private static List extractors = FXCollections.observableArrayList();
    private static final List valueExtractors;

    public static void addObservableValueExtractor(Predicate predicate, Callback callback) {
        extractors.add(new ValueExtractor$ObservableValueExtractor(predicate, callback));
    }

    public static final Optional getObservableValueExtractor(Control control) {
        for (ValueExtractor$ObservableValueExtractor valueExtractor$ObservableValueExtractor : extractors) {
            if (!valueExtractor$ObservableValueExtractor.applicability.test(control)) continue;
            return Optional.of(valueExtractor$ObservableValueExtractor.extraction);
        }
        return Optional.empty();
    }

    private ValueExtractor() {
    }

    public static void addValueExtractor(Predicate predicate, Callback callback) {
        valueExtractors.add(new ValueExtractor$NodeValueExtractor(predicate, callback));
    }

    public static Object getValue(Node node) {
        for (ValueExtractor$NodeValueExtractor valueExtractor$NodeValueExtractor : valueExtractors) {
            if (!valueExtractor$NodeValueExtractor.applicability.test(node)) continue;
            return valueExtractor$NodeValueExtractor.extraction.call((Object)node);
        }
        return null;
    }

    static {
        ValueExtractor.addObservableValueExtractor(control -> control instanceof TextInputControl, control -> ((TextInputControl)control).textProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof ComboBox, control -> ((ComboBox)control).valueProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof ChoiceBox, control -> ((ChoiceBox)control).valueProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof CheckBox, control -> ((CheckBox)control).selectedProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof Slider, control -> ((Slider)control).valueProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof ColorPicker, control -> ((ColorPicker)control).valueProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof DatePicker, control -> ((DatePicker)control).valueProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof ListView, control -> ((ListView)control).itemsProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof TableView, control -> ((TableView)control).itemsProperty());
        valueExtractors = FXCollections.observableArrayList();
        ValueExtractor.addValueExtractor(node -> node instanceof CheckBox, node -> ((CheckBox)node).isSelected());
        ValueExtractor.addValueExtractor(node -> node instanceof ChoiceBox, node -> ((ChoiceBox)node).getValue());
        ValueExtractor.addValueExtractor(node -> node instanceof ComboBox, node -> ((ComboBox)node).getValue());
        ValueExtractor.addValueExtractor(node -> node instanceof DatePicker, node -> (LocalDate)((DatePicker)node).getValue());
        ValueExtractor.addValueExtractor(node -> node instanceof RadioButton, node -> ((RadioButton)node).isSelected());
        ValueExtractor.addValueExtractor(node -> node instanceof Slider, node -> ((Slider)node).getValue());
        ValueExtractor.addValueExtractor(node -> node instanceof TextInputControl, node -> ((TextInputControl)node).getText());
        ValueExtractor.addValueExtractor(node -> node instanceof ListView, node -> {
            MultipleSelectionModel multipleSelectionModel = ((ListView)node).getSelectionModel();
            return multipleSelectionModel.getSelectionMode() == SelectionMode.MULTIPLE ? multipleSelectionModel.getSelectedItems() : multipleSelectionModel.getSelectedItem();
        });
        ValueExtractor.addValueExtractor(node -> node instanceof TreeView, node -> {
            MultipleSelectionModel multipleSelectionModel = ((TreeView)node).getSelectionModel();
            return multipleSelectionModel.getSelectionMode() == SelectionMode.MULTIPLE ? multipleSelectionModel.getSelectedItems() : multipleSelectionModel.getSelectedItem();
        });
        ValueExtractor.addValueExtractor(node -> node instanceof TableView, node -> {
            TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)node).getSelectionModel();
            return tableViewSelectionModel.getSelectionMode() == SelectionMode.MULTIPLE ? tableViewSelectionModel.getSelectedItems() : tableViewSelectionModel.getSelectedItem();
        });
        ValueExtractor.addValueExtractor(node -> node instanceof TreeTableView, node -> {
            TreeTableView.TreeTableViewSelectionModel treeTableViewSelectionModel = ((TreeTableView)node).getSelectionModel();
            return treeTableViewSelectionModel.getSelectionMode() == SelectionMode.MULTIPLE ? treeTableViewSelectionModel.getSelectedItems() : treeTableViewSelectionModel.getSelectedItem();
        });
    }
}

