/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.skin;

import impl.org.controlsfx.i18n.Localization;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DecimalStyle;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.TimePicker;
import org.controlsfx.control.TimePicker$Precision;
import org.controlsfx.control.cell.TimeCell;
import org.controlsfx.control.skin.TimePickerContent$TimeCellEventHandler;

public class TimePickerContent
extends VBox {
    private TimePicker timePicker;
    private List hourCells = new ArrayList();
    private List minuteCells = new ArrayList();
    private List secondCells = new ArrayList();
    private ObjectProperty lastFocusedHourCell = new SimpleObjectProperty();
    private ObjectProperty lastFocusedMinuteCell = new SimpleObjectProperty();
    private ObjectProperty lastFocusedSecondCell = new SimpleObjectProperty();
    private DateTimeFormatter hourCellFormatter = null;
    private static final DateTimeFormatter minuteCellFormatter = DateTimeFormatter.ofPattern("m");
    private static final DateTimeFormatter secondCellFormatter = DateTimeFormatter.ofPattern("s");
    private TimePickerContent$TimeCellEventHandler hourCellEventHandler = new TimePickerContent$TimeCellEventHandler(this, this.lastFocusedHourCell, TimePicker$Precision.HOUR);
    private TimePickerContent$TimeCellEventHandler minuteCellEventHandler = new TimePickerContent$TimeCellEventHandler(this, this.lastFocusedMinuteCell, TimePicker$Precision.MINUTE);
    private TimePickerContent$TimeCellEventHandler secondCellEventHandler = new TimePickerContent$TimeCellEventHandler(this, this.lastFocusedSecondCell, TimePicker$Precision.SECOND);
    private final Set selectedPrecisions = new HashSet();

    TimePickerContent(TimePicker timePicker) {
        this.timePicker = timePicker;
        timePicker.localeProperty().addListener(observable -> this.updateContent());
        this.getStyleClass().add((Object)"date-picker-popup");
        this.setSpacing(2.0);
        this.createHourCells();
        this.createMinuteCells();
        this.createSecondCells();
        if (timePicker.getValue() != null) {
            this.lastFocusedHourCell.set((Object)((TimeCell)((Object)this.hourCells.get(((LocalTime)timePicker.getValue()).getHour()))));
            this.lastFocusedMinuteCell.set((Object)((TimeCell)((Object)this.minuteCells.get(((LocalTime)timePicker.getValue()).getMinute()))));
            this.lastFocusedSecondCell.set((Object)((TimeCell)((Object)this.secondCells.get(((LocalTime)timePicker.getValue()).getSecond()))));
        }
        this.updateContent();
    }

    protected void createHourCells() {
        this.hourCellFormatter = this.usesAmPm(this.timePicker.getLocale()) ? DateTimeFormatter.ofPattern("h") : DateTimeFormatter.ofPattern("H");
        this.createTimeCells(12, 2, 3600000, this.hourCellFormatter, this.hourCellEventHandler, this.hourCells);
    }

    private TitledPane createHourSegment() {
        TitledPane titledPane = this.createTitledPane("timepicker.hour");
        int n2 = 12 + (this.usesAmPm(this.timePicker.getLocale()) ? 1 : 0);
        GridPane gridPane = this.createGridPane(n2, 12, 2, this.hourCells);
        if (this.usesAmPm(this.timePicker.getLocale())) {
            TimeCell timeCell = new TimeCell();
            timeCell.setText("AM");
            timeCell.getStyleClass().add((Object)"time-picker-am-pm-cell");
            gridPane.add((Node)timeCell, 0, 0);
            TimeCell timeCell2 = new TimeCell();
            timeCell2.setText("PM");
            timeCell2.getStyleClass().add((Object)"time-picker-am-pm-cell");
            gridPane.add((Node)timeCell2, 0, 1);
        }
        titledPane.setContent((Node)gridPane);
        return titledPane;
    }

    protected void createMinuteCells() {
        this.createTimeCells(10, 6, 60000, minuteCellFormatter, this.minuteCellEventHandler, this.minuteCells);
    }

    private TitledPane createMinuteSegment() {
        TitledPane titledPane = this.createTitledPane("timepicker.minute");
        GridPane gridPane = this.createGridPane(10, 10, 6, this.minuteCells);
        titledPane.setContent((Node)gridPane);
        return titledPane;
    }

    protected void createSecondCells() {
        this.createTimeCells(10, 6, 1000, secondCellFormatter, this.secondCellEventHandler, this.secondCells);
    }

    private TitledPane createSecondSegment() {
        TitledPane titledPane = this.createTitledPane("timepicker.second");
        GridPane gridPane = this.createGridPane(10, 10, 6, this.secondCells);
        titledPane.setContent((Node)gridPane);
        return titledPane;
    }

    public void updateContent() {
        TitledPane titledPane;
        this.getChildren().clear();
        this.selectedPrecisions.clear();
        TitledPane titledPane2 = this.createHourSegment();
        this.getChildren().add((Object)titledPane2);
        if (this.timePicker.getPrecision().equals((Object)TimePicker$Precision.MINUTE) || this.timePicker.getPrecision().equals((Object)TimePicker$Precision.SECOND)) {
            titledPane = this.createMinuteSegment();
            this.getChildren().add((Object)titledPane);
        }
        if (this.timePicker.getPrecision().equals((Object)TimePicker$Precision.SECOND)) {
            titledPane = this.createSecondSegment();
            this.getChildren().add((Object)titledPane);
        }
    }

    private TitledPane createTitledPane(String string) {
        TitledPane titledPane = new TitledPane();
        titledPane.setText(Localization.localize(Localization.asKey(string)));
        titledPane.setCollapsible(false);
        titledPane.getStyleClass().add((Object)"time-picker-titled-pane");
        return titledPane;
    }

    private GridPane createGridPane(int n2, int n3, int n4, List list) {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(Insets.EMPTY);
        gridPane.setVgap(-1.0);
        gridPane.setHgap(-1.0);
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                gridPane.add((Node)list.get(i2 * n3 + i3), i3 + n2 - n3, i2);
            }
        }
        return gridPane;
    }

    private boolean usesAmPm(Locale locale) {
        String string = DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.MEDIUM, FormatStyle.MEDIUM, IsoChronology.INSTANCE, locale);
        return string.contains("a");
    }

    private void createTimeCells(int n2, int n3, int n4, DateTimeFormatter dateTimeFormatter, TimePickerContent$TimeCellEventHandler timePickerContent$TimeCellEventHandler, List list) {
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                TimeCell timeCell = new TimeCell();
                timeCell.setDisable(false);
                timeCell.setStyle(null);
                timeCell.setGraphic(null);
                timeCell.setTooltip(null);
                int n5 = i2 * n2 + i3;
                LocalTime localTime = Instant.ofEpochMilli(n5 * n4).atOffset(ZoneOffset.UTC).toLocalTime();
                String string = dateTimeFormatter.withLocale(this.timePicker.getLocale()).withDecimalStyle(DecimalStyle.of(this.timePicker.getLocale())).format(localTime);
                timeCell.setText(string);
                timeCell.getStyleClass().add((Object)"time-picker-cell");
                this.timePicker.valueProperty().addListener(observable -> this.updateTimeCell(timeCell, list));
                this.updateTimeCell(timeCell, list);
                timeCell.addEventHandler(MouseEvent.MOUSE_CLICKED, timePickerContent$TimeCellEventHandler);
                timeCell.updateItem(localTime, false);
                list.add(timeCell);
            }
        }
    }

    private void updateTimeCell(TimeCell timeCell, List list) {
        for (TimeCell timeCell2 : list) {
            if (this.timePicker.getValue() != null && this.getValueBasedOnList((LocalTime)this.timePicker.getValue(), list) == this.getValueBasedOnList((LocalTime)timeCell2.getItem(), list)) continue;
            timeCell2.getStyleClass().remove((Object)"time-picker-cell-selected");
        }
        if (this.timePicker.getValue() != null && this.getValueBasedOnList((LocalTime)this.timePicker.getValue(), list) == this.getValueBasedOnList((LocalTime)timeCell.getItem(), list)) {
            timeCell.getStyleClass().add((Object)"time-picker-cell-selected");
        } else {
            timeCell.getStyleClass().remove((Object)"time-picker-cell-selected");
        }
    }

    private int getValueBasedOnList(LocalTime localTime, List list) {
        if (localTime == null) {
            return -1;
        }
        if (list == this.hourCells) {
            return localTime.getHour();
        }
        if (list == this.minuteCells) {
            return localTime.getMinute();
        }
        if (list == this.secondCells) {
            return localTime.getSecond();
        }
        return -1;
    }

    private void updateTimePickerValue() {
        int n2 = this.hourCells.indexOf(this.lastFocusedHourCell.get());
        n2 = n2 == -1 ? 0 : n2;
        int n3 = this.minuteCells.indexOf(this.lastFocusedMinuteCell.get());
        n3 = n3 == -1 ? 0 : n3;
        int n4 = this.secondCells.indexOf(this.lastFocusedSecondCell.get());
        n4 = n4 == -1 ? 0 : n4;
        int n5 = 0;
        LocalTime localTime = LocalTime.of(n2, n3, n4, n5);
        this.timePicker.setValue(localTime);
    }

    private void hidePopupOnCompletedSelection() {
        if (this.selectedPrecisions.size() == this.timePicker.getPrecision().getSegments()) {
            this.timePicker.hide();
        }
    }

    static /* synthetic */ void access$000(TimePickerContent timePickerContent) {
        timePickerContent.updateTimePickerValue();
    }

    static /* synthetic */ Set access$100(TimePickerContent timePickerContent) {
        return timePickerContent.selectedPrecisions;
    }

    static /* synthetic */ void access$200(TimePickerContent timePickerContent) {
        timePickerContent.hidePopupOnCompletedSelection();
    }
}

