/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.decoration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.controlsfx.ImplUtils;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.Decorator$1;
import org.controlsfx.control.skin.DecorationPane;

public class Decorator {
    private static final String DECORATIONS_PROPERTY_KEY = "$org.controlsfx.decorations$";
    private static List currentlyInstallingScenes = new ArrayList();
    private static Map pendingTasksByScene = new HashMap();

    private Decorator() {
    }

    public static final void addDecoration(Node node, Decoration decoration) {
        Decorator.getDecorations(node, true).add((Object)decoration);
        Decorator.updateDecorationsOnNode(node, (List)FXCollections.observableArrayList((Object[])new Decoration[]{decoration}), null);
    }

    public static final void removeDecoration(Node node, Decoration decoration) {
        Decorator.getDecorations(node, true).remove((Object)decoration);
        Decorator.updateDecorationsOnNode(node, null, (List)FXCollections.observableArrayList((Object[])new Decoration[]{decoration}));
    }

    public static final void removeAllDecorations(Node node) {
        ObservableList observableList = Decorator.getDecorations(node, true);
        ObservableList observableList2 = FXCollections.observableArrayList((Collection)observableList);
        node.getProperties().remove((Object)DECORATIONS_PROPERTY_KEY);
        Decorator.updateDecorationsOnNode(node, null, (List)observableList2);
    }

    public static final ObservableList getDecorations(Node node) {
        return Decorator.getDecorations(node, false);
    }

    private static final ObservableList getDecorations(Node node, boolean bl2) {
        ObservableList observableList = (ObservableList)node.getProperties().get((Object)DECORATIONS_PROPERTY_KEY);
        if (observableList == null && bl2) {
            observableList = FXCollections.observableArrayList();
            node.getProperties().put((Object)DECORATIONS_PROPERTY_KEY, (Object)observableList);
        }
        return observableList;
    }

    private static void updateDecorationsOnNode(Node node, List list, List list2) {
        Decorator.getDecorationPane(node, decorationPane -> decorationPane.updateDecorationsOnNode(node, list, list2));
    }

    private static void getDecorationPane(Node node, Consumer consumer) {
        DecorationPane decorationPane = Decorator.getDecorationPaneInParentHierarchy(node);
        if (decorationPane != null) {
            consumer.accept(decorationPane);
        } else {
            Consumer<Scene> consumer2 = scene -> {
                List list;
                if (currentlyInstallingScenes.contains(scene)) {
                    LinkedList<Consumer> linkedList = (LinkedList<Consumer>)pendingTasksByScene.get(scene);
                    if (linkedList == null) {
                        linkedList = new LinkedList<Consumer>();
                        pendingTasksByScene.put(scene, linkedList);
                    }
                    linkedList.add(consumer);
                    return;
                }
                DecorationPane decorationPane = Decorator.getDecorationPaneInParentHierarchy(node);
                if (decorationPane == null) {
                    currentlyInstallingScenes.add(scene);
                    decorationPane = new DecorationPane();
                    list = scene.getRoot();
                    ImplUtils.injectAsRootPane(scene, (Parent)decorationPane, true);
                    decorationPane.setRoot((Node)list);
                    currentlyInstallingScenes.remove(scene);
                }
                consumer.accept(decorationPane);
                list = (List)pendingTasksByScene.remove(scene);
                if (list != null) {
                    for (Consumer consumer2 : list) {
                        consumer2.accept(decorationPane);
                    }
                }
            };
            Scene scene2 = node.getScene();
            if (scene2 != null) {
                consumer2.accept(scene2);
            } else {
                Decorator$1 decorator$1 = new Decorator$1(node, consumer2);
                node.sceneProperty().addListener((InvalidationListener)decorator$1);
            }
        }
    }

    private static DecorationPane getDecorationPaneInParentHierarchy(Node node) {
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof DecorationPane)) continue;
            return (DecorationPane)parent;
        }
        return null;
    }
}

