/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import java.time.LocalTime;
import java.time.format.FormatStyle;
import java.util.Locale;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Skin;
import javafx.util.StringConverter;
import javafx.util.converter.LocalTimeStringConverter;
import org.controlsfx.control.TimePicker$Precision;
import org.controlsfx.control.skin.TimePickerSkin;

public class TimePicker
extends ComboBox {
    private final ObjectProperty precision = new SimpleObjectProperty((Object)this, "precision", null);
    private final ObjectProperty locale = new SimpleObjectProperty((Object)this, "locale", null);

    public TimePicker() {
        this(null);
    }

    public TimePicker(LocalTime localTime) {
        this.setValue(localTime);
        this.getStyleClass().add((Object)"time-picker");
        this.setEditable(true);
        this.setConverter(this.createStringConverter());
        this.precisionProperty().addListener((observableValue, timePicker$Precision, timePicker$Precision2) -> this.setConverter(this.createStringConverter()));
    }

    public TimePicker$Precision getPrecision() {
        return this.precision.get() == null ? TimePicker$Precision.MINUTE : (TimePicker$Precision)((Object)this.precision.get());
    }

    public void setPrecision(TimePicker$Precision timePicker$Precision) {
        this.precisionProperty().set((Object)timePicker$Precision);
    }

    public ObjectProperty precisionProperty() {
        return this.precision;
    }

    public Locale getLocale() {
        return this.locale.get() == null ? Locale.getDefault() : (Locale)this.locale.get();
    }

    public void setLocale(Locale locale) {
        this.localeProperty().set((Object)locale);
    }

    public ObjectProperty localeProperty() {
        return this.locale;
    }

    private StringConverter createStringConverter() {
        if (TimePicker$Precision.HOUR.equals((Object)this.getPrecision()) || TimePicker$Precision.MINUTE.equals((Object)this.getPrecision())) {
            return new LocalTimeStringConverter(FormatStyle.SHORT, this.getLocale());
        }
        return new LocalTimeStringConverter(FormatStyle.MEDIUM, this.getLocale());
    }

    protected Skin createDefaultSkin() {
        return new TimePickerSkin(this);
    }
}

