/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;

public class ImplUtils {
    private ImplUtils() {
    }

    public static void injectAsRootPane(Scene scene, Parent parent, boolean bl2) {
        Parent parent2 = scene.getRoot();
        scene.setRoot(parent);
        if (parent2 != null) {
            ImplUtils.getChildren(parent, bl2).add(0, parent2);
            parent.getProperties().putAll((Map)parent2.getProperties());
        }
    }

    public static void injectPane(Parent parent, Parent parent2, boolean bl2) {
        if (parent == null) {
            throw new IllegalArgumentException("parent can not be null");
        }
        List list = ImplUtils.getChildren(parent.getParent(), bl2);
        int n2 = list.indexOf(parent);
        list.remove(n2);
        list.add(n2, parent2);
        ImplUtils.getChildren(parent2, bl2).add(0, parent);
        parent2.getProperties().putAll((Map)parent.getProperties());
    }

    public static void stripRootPane(Scene scene, Parent parent, boolean bl2) {
        Parent parent2 = scene.getRoot();
        ImplUtils.getChildren(parent2, bl2).remove(parent);
        parent.getStyleClass().remove((Object)"root");
        scene.setRoot(parent);
    }

    public static List getChildren(Node node, boolean bl2) {
        return node instanceof Parent ? ImplUtils.getChildren((Parent)node, bl2) : Collections.emptyList();
    }

    public static List getChildren(Parent parent, boolean bl2) {
        ObservableList observableList = null;
        if (parent instanceof Pane) {
            observableList = ((Pane)parent).getChildren();
        } else if (parent instanceof Group) {
            observableList = ((Group)parent).getChildren();
        } else if (parent instanceof Control) {
            Control control = (Control)parent;
            Skin skin = control.getSkin();
            observableList = skin instanceof SkinBase ? ((SkinBase)skin).getChildren() : ImplUtils.getChildrenReflectively(parent);
        } else if (bl2) {
            observableList = ImplUtils.getChildrenReflectively(parent);
        }
        if (observableList == null) {
            throw new RuntimeException("Unable to get children for Parent of type " + parent.getClass() + ". useReflection is set to " + bl2);
        }
        return observableList == null ? FXCollections.emptyObservableList() : observableList;
    }

    public static ObservableList getChildrenReflectively(Parent parent) {
        ObservableList observableList = null;
        try {
            Method method = Parent.class.getDeclaredMethod("getChildren", new Class[0]);
            if (method != null) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                observableList = (ObservableList)method.invoke((Object)parent, new Object[0]);
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            throw new RuntimeException("Unable to get children for Parent of type " + parent.getClass(), exception);
        }
        return observableList;
    }
}

