/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.williams;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import java.util.List;

@StudyHeader(namespace="com.motivewave", id="FRACTAL", rb="com.motivewave.platform.study.nls.strings", name="TITLE_FRACTAL", desc="DESC_FRACTAL", menu="MENU_OVERLAY", menu2="MENU_BILL_WILLIAMS", overlay=true, helpLink="http://www.motivewave.com/studies/fractal.htm")
public class a
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("strength", this.get("LBL_STRENGTH", new Object[0]), 2, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"strength"});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onBarClose(DataContext dataContext) {
        this.calculateValues(dataContext);
    }

    protected void calculateValues(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        this.clearFigures();
        List list = dataSeries.calcSwingPoints(this.getSettings().getInteger("strength", 2));
        MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
        MarkerInfo markerInfo2 = this.getSettings().getMarker("downMarker");
        list.forEach(swingPoint -> {
            if (swingPoint.isTop() && markerInfo2.isEnabled()) {
                this.addFigure((Figure)new Marker(swingPoint.getCoordinate(), Enums.Position.BOTTOM, markerInfo));
            } else if (!swingPoint.isTop() && markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(swingPoint.getCoordinate(), Enums.Position.TOP, markerInfo2));
            }
        });
    }
}

