/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.williams;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.williams.MarketFaciliationIndex$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="MKT_FAC_IND", rb="com.motivewave.platform.study.nls.strings", name="TITLE_MKT_FAC_IND", desc="DESC_MKT_FAC_IND", menu="MENU_BILL_WILLIAMS", overlay=false, helpLink="http://www.motivewave.com/studies/market_facilitation_index.htm")
public class MarketFaciliationIndex
extends Study {
    protected static final String a = "mfiUpVolUpColor";
    protected static final String b = "mfiDownVolDownColor";
    protected static final String c = "mfiUpVolDownColor";
    protected static final String d = "mfiDownVolUpColor";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor(a, this.get("LBL_MFI_UP_VOL_UP", new Object[0]), defaults.getGreen())});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor(b, this.get("LBL_MFI_DOWN_VOL_DOWN", new Object[0]), defaults.getBrown())});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor(c, this.get("LBL_MFI_UP_VOL_DOWN", new Object[0]), defaults.getBlue())});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor(d, this.get("LBL_MFI_DOWN_VOL_UP", new Object[0]), defaults.getRed())});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[0]);
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MarketFaciliationIndex$Values.MFI, this.get("LBL_MFI", new Object[0]), new String[0]));
        runtimeDescriptor.declareBars((Object)MarketFaciliationIndex$Values.MFI);
        runtimeDescriptor.declareIndicator((Object)MarketFaciliationIndex$Values.MFI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{MarketFaciliationIndex$Values.MFI});
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.setBottomInsetPixels(0);
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        double d2 = 0.0;
        DataSeries dataSeries = dataContext.getDataSeries();
        long l2 = dataSeries.getVolume(n2);
        if (l2 > 0L) {
            d2 = (double)(dataSeries.getHigh(n2) - dataSeries.getLow(n2)) * 1000.0 / (double)l2;
        }
        dataSeries.setDouble(n2, (Object)MarketFaciliationIndex$Values.MFI, Double.valueOf(d2));
        if (n2 <= 1) {
            return;
        }
        Double d3 = dataSeries.getDouble(n2 - 1, (Object)MarketFaciliationIndex$Values.MFI);
        if (d3 == null) {
            return;
        }
        long l3 = dataSeries.getVolume(n2 - 1);
        Color color = this.getSettings().getColor(a);
        if (d2 < d3 && l2 < l3) {
            color = this.getSettings().getColor(b);
        } else if (d2 > d3 && l2 < l3) {
            color = this.getSettings().getColor(c);
        } else if (d2 < d3 && l2 > l3) {
            color = this.getSettings().getColor(d);
        }
        dataSeries.setBarColor(n2, (Object)MarketFaciliationIndex$Values.MFI, color);
        dataSeries.setComplete(n2);
    }
}

