/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.williams;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.williams.GatorOsc$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="GATOR_OSC", rb="com.motivewave.platform.study.nls.strings", name="TITLE_GATOR_OSC", label="LBL_GATOR_OSC", desc="DESC_GATOR_OSC", menu="MENU_BILL_WILLIAMS", overlay=false, helpLink="http://www.motivewave.com/studies/gator_oscillator.htm")
public class GatorOsc
extends Study {
    static final String a = "jawPeriod";
    static final String b = "jawShift";
    static final String c = "teethPeriod";
    static final String d = "teethShift";
    static final String e = "lipsPeriod";
    static final String f = "lipsShift";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_JAW_PERIOD", new Object[0]), 13, 1, 9999, 1), new IntegerDescriptor(b, this.get("LBL_SHIFT", new Object[0]), 8, -999, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("LBL_TEETH_PERIOD", new Object[0]), 8, 1, 9999, 1), new IntegerDescriptor(d, this.get("LBL_SHIFT", new Object[0]), 5, -999, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(e, this.get("LBL_LIPS_PERIOD", new Object[0]), 5, 1, 9999, 1), new IntegerDescriptor(f, this.get("LBL_SHIFT", new Object[0]), 3, -999, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_SETTINGS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("topInd", this.get("LBL_TOP_IND", new Object[0]), null, null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("bottomInd", this.get("LBL_BOTTOM_IND", new Object[0]), null, null, false, true, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", a, c, e});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)GatorOsc$Values.TOP, this.get("LBL_GATOR_TOP", new Object[0]), new String[]{"input", "method", a, c}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)GatorOsc$Values.BOTTOM, this.get("LBL_GATOR_BOTTOM", new Object[0]), new String[]{"input", "method", c, e}));
        runtimeDescriptor.declareBars((Object)GatorOsc$Values.TOP, null);
        runtimeDescriptor.declareBars((Object)GatorOsc$Values.BOTTOM, null);
        runtimeDescriptor.declareIndicator((Object)GatorOsc$Values.TOP, "topInd");
        runtimeDescriptor.declareIndicator((Object)GatorOsc$Values.BOTTOM, "bottomInd");
        runtimeDescriptor.setRangeKeys(new Object[]{GatorOsc$Values.TOP, GatorOsc$Values.BOTTOM});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculateValues(DataContext dataContext) {
        boolean bl2 = this.getSettings().isBarUpdates();
        Util.calcSeriesMA((DataContext)dataContext, (Enums.MAMethod)this.getSettings().getMAMethod("method"), (Object)this.getSettings().getInput("input"), (int)this.getSettings().getInteger(a), (int)this.getSettings().getInteger(b), (Object)((Object)GatorOsc$Values.JAW), (boolean)false, (boolean)bl2);
        Util.calcSeriesMA((DataContext)dataContext, (Enums.MAMethod)this.getSettings().getMAMethod("method"), (Object)this.getSettings().getInput("input"), (int)this.getSettings().getInteger(c), (int)this.getSettings().getInteger(d), (Object)((Object)GatorOsc$Values.TEETH), (boolean)false, (boolean)bl2);
        Util.calcSeriesMA((DataContext)dataContext, (Enums.MAMethod)this.getSettings().getMAMethod("method"), (Object)this.getSettings().getInput("input"), (int)this.getSettings().getInteger(e), (int)this.getSettings().getInteger(f), (Object)((Object)GatorOsc$Values.LIPS), (boolean)false, (boolean)bl2);
        int n2 = Util.maxInt((int[])new int[]{this.getSettings().getInteger(b), this.getSettings().getInteger(d), this.getSettings().getInteger(f)});
        DataSeries dataSeries = dataContext.getDataSeries();
        for (int i2 = 0; i2 < dataSeries.size() + n2; ++i2) {
            if (dataSeries.isComplete(i2) || !bl2 && !dataSeries.isBarComplete(i2)) continue;
            this.calculate(i2, dataContext);
        }
        super.calculateValues(dataContext);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Double d2;
        double d3;
        DataSeries dataSeries = dataContext.getDataSeries();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        Double d4 = dataSeries.getDouble(n2, (Object)GatorOsc$Values.JAW);
        Double d5 = dataSeries.getDouble(n2, (Object)GatorOsc$Values.TEETH);
        Double d6 = dataSeries.getDouble(n2, (Object)GatorOsc$Values.LIPS);
        boolean bl2 = false;
        if (d4 != null && d5 != null) {
            d3 = Math.abs(d4 - d5);
            d2 = dataSeries.getDouble(n2 - 1, (Object)GatorOsc$Values.TOP);
            dataSeries.setDouble(n2, (Object)GatorOsc$Values.TOP, Double.valueOf(d3));
            dataSeries.setBarColor(n2, (Object)GatorOsc$Values.TOP, d2 == null || d3 > d2 ? color : color2);
            boolean bl3 = bl2 = dataSeries.isComplete(n2, (Object)GatorOsc$Values.JAW) && dataSeries.isComplete(n2, (Object)GatorOsc$Values.TEETH);
        }
        if (d5 != null && d6 != null) {
            d3 = -Math.abs(d5 - d6);
            d2 = dataSeries.getDouble(n2 - 1, (Object)GatorOsc$Values.BOTTOM);
            dataSeries.setDouble(n2, (Object)GatorOsc$Values.BOTTOM, Double.valueOf(d3));
            dataSeries.setBarColor(n2, (Object)GatorOsc$Values.BOTTOM, d2 == null || d3 < d2 ? color : color2);
            bl2 = bl2 && dataSeries.isComplete(n2, (Object)GatorOsc$Values.TEETH) && dataSeries.isComplete(n2, (Object)GatorOsc$Values.LIPS);
        } else {
            bl2 = false;
        }
        dataSeries.setComplete(n2, bl2);
    }
}

