/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.williams;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.williams.DivergentBars$Signals;

@StudyHeader(namespace="com.motivewave", id="ID_DIV_BARS", rb="com.motivewave.platform.study.nls.strings2", name="NAME_DIVERGENT_BARS", desc="DESC_DIVERGENT", menu="MENU_BILL_WILLIAMS", helpLink="http://www.motivewave.com/studies/divergent_bars.htm", signals=true, overlay=true, studyOverlay=true)
public class DivergentBars
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DivergentBars$Signals.BULL, Enums.ValueType.BOOLEAN, this.get("BULL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DivergentBars$Signals.BEAR, Enums.ValueType.BOOLEAN, this.get("BEAR", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)DivergentBars$Signals.BULL, this.get("BULL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DivergentBars$Signals.BEAR, this.get("BEAR", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
        this.setMinBars(20);
    }

    protected synchronized void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        DataSeries dataSeries = dataContext.getDataSeries();
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        double d2 = dataSeries.getLow(n2);
        double d3 = dataSeries.getHigh(n2);
        float f2 = dataSeries.getClose(n2);
        double d4 = dataSeries.getLow(n2 - 1);
        double d5 = dataSeries.getHigh(n2 - 1);
        double d6 = (d3 + d2) / 2.0;
        boolean bl2 = d2 < d4 && (double)f2 > d6;
        boolean bl3 = d3 > d5 && (double)f2 < d6;
        dataSeries.setBoolean(n2, (Object)DivergentBars$Signals.BEAR, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)DivergentBars$Signals.BULL, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), (double)dataSeries.getHigh(n2));
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("DIVERGENT_BEAR_CLOSING_PRICE", new Object[]{Float.valueOf(f2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DivergentBars$Signals.BEAR, string, (Object)Float.valueOf(f2));
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), (double)dataSeries.getLow(n2));
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("DIVERGENT_BULL_CLOSING_PRICE", new Object[]{Float.valueOf(f2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DivergentBars$Signals.BULL, string, (Object)Float.valueOf(f2));
        }
        dataSeries.setComplete(n2);
    }
}

