/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.williams;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.williams.AccelerationOsc$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ACCEL_OSC", rb="com.motivewave.platform.study.nls.strings", name="TITLE_ACCEL_OSC", label="LBL_ACCEL_OSC", desc="DESC_ACCEL_OSC", menu="MENU_BILL_WILLIAMS", overlay=false, helpLink="http://www.motivewave.com/studies/acceleration_oscillator.htm")
public class AccelerationOsc
extends Study {
    static final String a = "accelPeriod";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("slowPeriod", this.get("LBL_SLOW_PERIOD", new Object[0]), 34, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("fastPeriod", this.get("LBL_FAST_PERIOD", new Object[0]), 5, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_ACCEL_PERIOD", new Object[0]), 5, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_SETTINGS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "slowPeriod", "fastPeriod", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AccelerationOsc$Values.VAL, this.get("LBL_ACCEL_OSC", new Object[0]), new String[]{"input", "method", "slowPeriod", "fastPeriod", a}));
        runtimeDescriptor.declareBars((Object)AccelerationOsc$Values.VAL);
        runtimeDescriptor.declareIndicator((Object)AccelerationOsc$Values.VAL, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{AccelerationOsc$Values.VAL});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("slowPeriod");
        int n4 = this.getSettings().getInteger("fastPeriod");
        if (n2 <= n3) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Object object = this.getSettings().getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.ma(mAMethod, n2, n3, object);
        Double d3 = dataSeries.ma(mAMethod, n2, n4, object);
        if (d2 == null || d3 == null) {
            return;
        }
        double d4 = d3 - d2;
        dataSeries.setDouble(n2, (Object)AccelerationOsc$Values.AO, Double.valueOf(d4));
        int n5 = this.getSettings().getInteger(a);
        if (n2 <= n3 + n5) {
            return;
        }
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        Double d5 = dataSeries.ma(mAMethod, n2, n5, (Object)AccelerationOsc$Values.AO);
        if (d5 == null) {
            return;
        }
        double d6 = d4 - d5;
        dataSeries.setDouble(n2, (Object)AccelerationOsc$Values.VAL, Double.valueOf(d6));
        Double d7 = dataSeries.getDouble(n2 - 1, (Object)AccelerationOsc$Values.VAL);
        Color color3 = color;
        if (d7 != null && d7 > d6) {
            color3 = color2;
        }
        dataSeries.setBarColor(n2, (Object)AccelerationOsc$Values.VAL, color3);
        dataSeries.setComplete(n2);
    }
}

