/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.wilder;

import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.wilder.VolatilityIndex;
import com.motivewave.platform.study.wilder.VolatilityIndex$Values;

@StudyHeader(namespace="com.motivewave", id="VX_STRATEGY", rb="com.motivewave.platform.study.nls.strings", name="TITLE_VX_STRATEGY", desc="DESC_VX_STRATEGY", menu="MENU_WELLES_WILDER", helpLink="http://www.motivewave.com/strategies/volatility_index_strategy.htm", overlay=true, signals=true, strategy=true, autoEntry=true, manualEntry=false, supportsStopPL=true, supportsUnrealizedPL=true, supportsRealizedPL=true, supportsTotalPL=true)
public class d
extends VolatilityIndex {
    static final String a = "TRADE_OCCURRED";

    public void onActivate(OrderContext orderContext) {
        super.onActivate(orderContext);
        if (this.getSettings().isEnterOnActivate()) {
            DataSeries dataSeries = orderContext.getDataContext().getDataSeries();
            Boolean bl2 = dataSeries.getBoolean(dataSeries.size() - 2, (Object)VolatilityIndex$Values.LONG);
            if (bl2 == null) {
                return;
            }
            int n2 = this.getSettings().getTradeLots();
            n2 = (int)((float)n2 * orderContext.getInstrument().getDefaultQuantityAsFloat());
            float f2 = n2;
            if (bl2.booleanValue()) {
                orderContext.buy(f2);
            } else {
                orderContext.sell(f2);
            }
        }
    }

    public void onDeactivate(OrderContext orderContext) {
        if (this.getSettings().isCloseOnDeactivate()) {
            orderContext.closeAtMarket();
        }
        super.onDeactivate(orderContext);
    }

    public void onBarClose(OrderContext orderContext) {
        DataSeries dataSeries = orderContext.getDataContext().getDataSeries();
        Instrument instrument = orderContext.getInstrument();
        if (dataSeries.getBoolean((Object)a, false)) {
            Double d2 = dataSeries.getDouble((Object)VolatilityIndex$Values.SAR);
            if (d2 != null) {
                this.setStopPrice(Float.valueOf((float)instrument.round(d2.doubleValue())));
            }
            return;
        }
        Double d3 = dataSeries.getDouble(dataSeries.size() - 2, (Object)VolatilityIndex$Values.SAR);
        Boolean bl2 = dataSeries.getBoolean(dataSeries.size() - 2, (Object)VolatilityIndex$Values.LONG);
        if (d3 == null || bl2 == null) {
            return;
        }
        float f2 = (float)instrument.round(d3.doubleValue());
        this.setStopPrice(Float.valueOf(f2));
        float f3 = orderContext.getPositionAsFloat();
        int n2 = this.getSettings().getTradeLots();
        n2 = (int)((float)n2 * (instrument.getDefaultQuantityAsFloat() + Math.abs(f3)));
        float f4 = n2;
        float f5 = dataSeries.getClose();
        if (bl2.booleanValue() && f5 <= f2) {
            orderContext.sell(f4);
            dataSeries.setBoolean(dataSeries.size() - 1, (Object)a, Boolean.valueOf(true));
        } else if (!bl2.booleanValue() && f5 >= f2) {
            orderContext.buy(f4);
            dataSeries.setBoolean(dataSeries.size() - 1, (Object)a, Boolean.valueOf(true));
        }
    }
}

