/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.wilder;

import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.wilder.RSI;
import com.motivewave.platform.study.wilder.RSI$Signals;
import com.motivewave.platform.study.wilder.RSI$Values;

@StudyHeader(namespace="com.motivewave", id="RSI_STRATEGY", rb="com.motivewave.platform.study.nls.strings", name="TITLE_RSI_STRATEGY", desc="DESC_RSI_STRATEGY", menu="MENU_WELLES_WILDER", overlay=false, signals=true, strategy=true, autoEntry=true, manualEntry=false, supportsUnrealizedPL=true, supportsRealizedPL=true, supportsTotalPL=true, supportsPositionType=true)
public class b
extends RSI {
    public void onActivate(OrderContext orderContext) {
        if (this.getSettings().isEnterOnActivate()) {
            DataSeries dataSeries;
            int n2 = (dataSeries = orderContext.getDataContext().getDataSeries()).isLastBarComplete() ? dataSeries.size() - 1 : dataSeries.size() - 2;
            Double d2 = dataSeries.getDouble(n2, (Object)RSI$Values.RSI);
            if (d2 == null) {
                return;
            }
            int n3 = this.getSettings().getTradeLots();
            n3 = (int)((float)n3 * orderContext.getInstrument().getDefaultQuantityAsFloat());
            float f2 = n3;
            switch (this.getSettings().getPositionType()) {
                case LONG: {
                    if (!(d2 < 50.0)) break;
                    orderContext.buy(f2);
                    break;
                }
                case SHORT: {
                    if (!(d2 > 50.0)) break;
                    orderContext.sell(f2);
                    break;
                }
                default: {
                    if (d2 < 50.0) {
                        orderContext.buy(f2);
                        break;
                    }
                    orderContext.sell(f2);
                }
            }
        }
    }

    public void onBarClose(OrderContext orderContext) {
        DataSeries dataSeries = orderContext.getDataContext().getDataSeries();
        Instrument instrument = orderContext.getInstrument();
        float f2 = orderContext.getPositionAsFloat();
        float f3 = (float)this.getSettings().getTradeLots() * instrument.getDefaultQuantityAsFloat();
        switch (this.getSettings().getPositionType()) {
            case LONG: {
                if (f2 == 0.0f && dataSeries.getBoolean((Object)RSI$Signals.RSI_BOTTOM, false)) {
                    orderContext.buy(f3);
                }
                if (!(f2 > 0.0f) || !dataSeries.getBoolean((Object)RSI$Signals.RSI_TOP, false)) break;
                orderContext.sell(f3);
                break;
            }
            case SHORT: {
                if (f2 == 0.0f && dataSeries.getBoolean((Object)RSI$Signals.RSI_TOP, false)) {
                    orderContext.sell(f3);
                }
                if (!(f2 < 0.0f) || !dataSeries.getBoolean((Object)RSI$Signals.RSI_BOTTOM, false)) break;
                orderContext.buy(f3);
                break;
            }
            default: {
                f3 += Math.abs(f2);
                if (f2 <= 0.0f && dataSeries.getBoolean((Object)RSI$Signals.RSI_BOTTOM, false)) {
                    orderContext.buy(f3);
                }
                if (!(f2 >= 0.0f) || !dataSeries.getBoolean((Object)RSI$Signals.RSI_TOP, false)) break;
                orderContext.sell(f3);
            }
        }
    }
}

