/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.wilder;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.wilder.VolatilityIndex$Signals;
import com.motivewave.platform.study.wilder.VolatilityIndex$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="VOLATILITY_INDEX", rb="com.motivewave.platform.study.nls.strings", name="TITLE_VOLATILITY_INDEX", desc="DESC_VOLATILITY_INDEX", menu="MENU_OVERLAY", menu2="MENU_WELLES_WILDER", overlay=true, signals=true, helpLink="http://www.motivewave.com/studies/volatility_index.htm")
public class VolatilityIndex
extends Study {
    static final String b = "constant";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.a(settingTab);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period", b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolatilityIndex$Values.SAR, this.get("VAL_VIX", new Object[0]), new String[]{"period", b}));
        runtimeDescriptor.declarePath((Object)VolatilityIndex$Values.SAR, "line");
        runtimeDescriptor.declareIndicator((Object)VolatilityIndex$Values.SAR, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{VolatilityIndex$Values.SAR});
        runtimeDescriptor.declareSignal((Object)VolatilityIndex$Signals.SAR_LONG, this.get("LBL_SAR_LONG", new Object[0]));
        runtimeDescriptor.declareSignal((Object)VolatilityIndex$Signals.SAR_SHORT, this.get("LBL_SAR_SHORT", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void a(SettingTab settingTab) {
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 7, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("LBL_CONSTANT", new Object[0]), 3.0, 0.001, 99.999, 0.001)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        Color color = new Color(95, 165, 220);
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_SAR", new Object[0]), color, Enums.PointType.DOT, Enums.Size.SMALL, true, true, false);
        pathDescriptor.setSupportsMaxPoints(true);
        pathDescriptor.setSupportsColorPolicy(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), color, Color.WHITE, false, false, true)});
        settingTab.addGroup(settingGroup2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        boolean bl2;
        int n3 = this.getSettings().getInteger("period", 7);
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Double d2 = dataSeries.getDouble(n2 - 1, (Object)VolatilityIndex$Values.SAR);
        Double d3 = dataSeries.getDouble(n2 - 1, (Object)VolatilityIndex$Values.ATR);
        double d4 = this.getSettings().getDouble(b, 3.0);
        Double d5 = dataSeries.getDouble(n2 - 1, (Object)VolatilityIndex$Values.SIC);
        Boolean bl3 = dataSeries.getBoolean(n2 - 1, (Object)VolatilityIndex$Values.LONG);
        Instrument instrument = dataContext.getInstrument();
        boolean bl4 = bl2 = n2 == dataSeries.size() - 1;
        if (d2 == null) {
            bl3 = dataSeries.getClose(n2) > dataSeries.getClose(n2 - 1);
            d3 = dataSeries.atr(n3);
            d5 = dataSeries.getClose(n2 - 1);
            d2 = bl3.booleanValue() ? Double.valueOf(instrument.round(d5 - d3 * d4)) : Double.valueOf(instrument.round(d5 + d3 * d4));
        } else {
            d3 = ((double)(n3 - 1) * d3 + (double)dataSeries.getTrueRange(n2).floatValue()) / (double)n3;
        }
        double d6 = d3 * d4;
        double d7 = dataSeries.getClose(n2);
        if (bl3.booleanValue()) {
            if (d7 <= d2) {
                bl3 = false;
                dataSeries.setBoolean(n2, (Object)VolatilityIndex$Signals.SAR_LONG, Boolean.valueOf(true));
                if (!bl2) {
                    dataContext.signal(n2, (Object)VolatilityIndex$Signals.SAR_LONG, this.get("SIGNAL_SAR_LONG", new Object[]{instrument.format(d7), instrument.format(d2.doubleValue())}), (Object)d7);
                }
                d5 = d7;
                d2 = instrument.round(d5 + d6);
            } else {
                d5 = Util.max((double)d5, (double)d7);
                d2 = instrument.round(d5 - d6);
            }
        } else if (d7 >= d2) {
            bl3 = true;
            dataSeries.setBoolean(n2, (Object)VolatilityIndex$Signals.SAR_SHORT, Boolean.valueOf(true));
            if (!bl2) {
                dataContext.signal(n2, (Object)VolatilityIndex$Signals.SAR_SHORT, this.get("SIGNAL_SAR_SHORT", new Object[]{instrument.format(d7), instrument.format(d2.doubleValue())}), (Object)d7);
            }
            d5 = d7;
            d2 = instrument.round(d5 - d6);
        } else {
            d5 = Util.min((double[])new double[]{d5, d7});
            d2 = instrument.round(d5 + d6);
        }
        dataSeries.setDouble(n2, (Object)VolatilityIndex$Values.SAR, d2);
        dataSeries.setDouble(n2, (Object)VolatilityIndex$Values.SIC, d5);
        dataSeries.setDouble(n2, (Object)VolatilityIndex$Values.ATR, d3);
        dataSeries.setBoolean(n2, (Object)VolatilityIndex$Values.LONG, bl3);
        dataSeries.setComplete(n2);
    }
}

