/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.wilder;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.wilder.RSI$Signals;
import com.motivewave.platform.study.wilder.RSI$Values;

@StudyHeader(namespace="com.motivewave", id="RSI", rb="com.motivewave.platform.study.nls.strings", name="TITLE_RSI", label="LBL_RSI", desc="DESC_RSI", menu="MENU_WELLES_WILDER", menu2="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/rsi.htm")
public class RSI
extends Study {
    static final String a = "rsiLine";
    static final String b = "rsiInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(a, this.get("LBL_RSI_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", a, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", a, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("LBL_RSI_IND", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 70.0, 1.0, 100.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide2", this.get("LBL_TOP_GUIDE2", new Object[0]), 60.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setEnabled(false);
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 1.0, 100.0, 1.0, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        guideDescriptor = new GuideDescriptor("bottomGuide2", this.get("LBL_BOTTOM_GUIDE2", new Object[0]), 40.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setEnabled(false);
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 30.0, 1.0, 100.0, 1.0, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RSI$Values.RSI, this.get("LBL_RSI", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)RSI$Values.RSI, a);
        runtimeDescriptor.declareIndicator((Object)RSI$Values.RSI, b);
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(15));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(85));
        runtimeDescriptor.setRangeKeys(new Object[]{RSI$Values.RSI});
        runtimeDescriptor.declareSignal((Object)RSI$Signals.RSI_TOP, this.get("RSI_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RSI$Signals.RSI_BOTTOM, this.get("RSI_BOTTOM", new Object[0]));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = this.getSettings().getInput("input");
        double d2 = dataSeries.getDouble(n2, object) - dataSeries.getDouble(n2 - 1, object);
        double d3 = 0.0;
        double d4 = 0.0;
        if (d2 > 0.0) {
            d3 = d2;
        } else {
            d4 = d2;
        }
        dataSeries.setDouble(n2, (Object)RSI$Values.UP, Double.valueOf(d3));
        dataSeries.setDouble(n2, (Object)RSI$Values.DOWN, Double.valueOf(Math.abs(d4)));
        if (n2 <= n3 + 1) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Double d5 = dataSeries.ma(mAMethod, n2, n3, (Object)RSI$Values.UP);
        Double d6 = dataSeries.ma(mAMethod, n2, n3, (Object)RSI$Values.DOWN);
        if (d5 == null || d6 == null) {
            return;
        }
        double d7 = d5 / d6;
        double d8 = 100.0 - 100.0 / (1.0 + d7);
        dataSeries.setDouble(n2, (Object)RSI$Values.RSI, Double.valueOf(d8));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        if (this.crossedAbove(dataSeries, n2, (Object)RSI$Values.RSI, guideInfo.getValue())) {
            dataSeries.setBoolean(n2, (Object)RSI$Signals.RSI_TOP, Boolean.valueOf(true));
            dataContext.signal(n2, (Object)RSI$Signals.RSI_TOP, this.get("SIGNAL_RSI_TOP", new Object[]{guideInfo.getValue(), this.round(d8)}), (Object)this.round(d8));
        } else if (this.crossedBelow(dataSeries, n2, (Object)RSI$Values.RSI, guideInfo2.getValue())) {
            dataSeries.setBoolean(n2, (Object)RSI$Signals.RSI_BOTTOM, Boolean.valueOf(true));
            dataContext.signal(n2, (Object)RSI$Signals.RSI_BOTTOM, this.get("SIGNAL_RSI_BOTTOM", new Object[]{guideInfo2.getValue(), this.round(d8)}), (Object)this.round(d8));
        }
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

