/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.wilder;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.wilder.DMI$Values;

@StudyHeader(namespace="com.motivewave", id="DMI", rb="com.motivewave.platform.study.nls.strings", name="TITLE_DMI", label="LBL_DMI", desc="DESC_DMI", menu="MENU_WELLES_WILDER", overlay=false, studyOverlay=true, helpLink="http://www.motivewave.com/studies/directional_movement_indicator.htm")
public class DMI
extends Study {
    static final String a = "pdiLine";
    static final String b = "ndiLine";
    static final String c = "pdiInd";
    static final String d = "ndiInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(a, this.get("LBL_PDI_LINE", new Object[0]), defaults.getGreen(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b, this.get("LBL_NDI_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(c, this.get("LBL_PDI_IND", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(d, this.get("LBL_NDI_IND", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 40.0, 1.0, 100.0, 1.0, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 20.0, 1.0, 100.0, 1.0, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DMI$Values.PDI, this.get("LBL_PDI", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DMI$Values.NDI, this.get("LBL_NDI", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)DMI$Values.PDI, a);
        runtimeDescriptor.declarePath((Object)DMI$Values.NDI, b);
        runtimeDescriptor.declareIndicator((Object)DMI$Values.PDI, c);
        runtimeDescriptor.declareIndicator((Object)DMI$Values.NDI, d);
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.setRangeKeys(new Object[]{DMI$Values.PDI, DMI$Values.NDI});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Float f2 = dataSeries.getPositiveDM(n2);
        Float f3 = dataSeries.getNegativeDM(n2);
        Float f4 = dataSeries.getTrueRange(n2);
        dataSeries.setFloat(n2, (Object)DMI$Values.PDM, f2);
        dataSeries.setFloat(n2, (Object)DMI$Values.NDM, f3);
        dataSeries.setFloat(n2, (Object)DMI$Values.TR, f4);
        if (n2 <= n3) {
            return;
        }
        Double d2 = dataSeries.smma(n2, n3, (Object)DMI$Values.PDM);
        Double d3 = dataSeries.smma(n2, n3, (Object)DMI$Values.NDM);
        Double d4 = dataSeries.smma(n2, n3, (Object)DMI$Values.TR);
        double d5 = d2 / d4 * 100.0;
        double d6 = d3 / d4 * 100.0;
        double d7 = Math.abs(d2 - d3) / (d2 + d3) * 100.0;
        dataSeries.setDouble(n2, (Object)DMI$Values.DX, Double.valueOf(d7));
        dataSeries.setDouble(n2, (Object)DMI$Values.PDI, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)DMI$Values.NDI, Double.valueOf(d6));
        dataSeries.setComplete(n2);
    }
}

