/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.wilder;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.wilder.ADX$Values;
import java.util.ArrayList;

@StudyHeader(namespace="com.motivewave", id="ADX", rb="com.motivewave.platform.study.nls.strings", name="TITLE_ADX", label="LBL_ADX", desc="DESC_ADX", menu="MENU_WELLES_WILDER", overlay=false, studyOverlay=true, helpLink="http://www.motivewave.com/studies/average_directional_index.htm")
public class ADX
extends Study {
    static final String a = "adxLine";
    static final String b = "pdiLine";
    static final String c = "ndiLine";
    static final String d = "histogram";
    static final String e = "adxInd";
    static final String f = "pdiInd";
    static final String g = "ndiInd";
    static final String h = "histInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor(a, this.get("LBL_ADX_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        PathDescriptor pathDescriptor2 = new PathDescriptor(b, this.get("LBL_PDI_LINE", new Object[0]), defaults.getGreen(), 1.0f, null, true, false, true);
        pathDescriptor2.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor2});
        PathDescriptor pathDescriptor3 = new PathDescriptor(c, this.get("LBL_NDI_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true);
        pathDescriptor3.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor3});
        PathDescriptor pathDescriptor4 = new PathDescriptor(d, this.get("LBL_HISTOGRAM", new Object[0]), defaults.getGreen(), 1.0f, null, false, false, true);
        pathDescriptor4.setColorPolicy(Enums.ColorPolicy.POSITIVE_NEGATIVE);
        pathDescriptor4.setColor2(defaults.getRed());
        pathDescriptor4.setSupportsShowAsBars(true);
        pathDescriptor4.setShowAsBars(true);
        pathDescriptor4.setColorPolicies(Enums.ColorPolicy.values());
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor4});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(e, this.get("LBL_ADX_IND", new Object[0]), null, null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("LBL_PDI_IND", new Object[0]), defaults.getGreen(), null, false, false, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("LBL_NDI_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(h, this.get("LBL_HIST_IND", new Object[0]), null, null, false, false, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 40.0, 1.0, 100.0, 1.0, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 20.0, 1.0, 100.0, 1.0, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ADX$Values.ADX, this.get("LBL_ADX", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ADX$Values.PDI, this.get("LBL_PDI", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ADX$Values.NDI, this.get("LBL_NDI", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ADX$Values.HIST, this.get("LBL_HISTOGRAM", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)ADX$Values.ADX, a);
        runtimeDescriptor.declarePath((Object)ADX$Values.PDI, b);
        runtimeDescriptor.declarePath((Object)ADX$Values.NDI, c);
        runtimeDescriptor.declarePath((Object)ADX$Values.HIST, d);
        runtimeDescriptor.declareIndicator((Object)ADX$Values.ADX, e);
        runtimeDescriptor.declareIndicator((Object)ADX$Values.PDI, f);
        runtimeDescriptor.declareIndicator((Object)ADX$Values.NDI, g);
        runtimeDescriptor.declareIndicator((Object)ADX$Values.HIST, h);
        runtimeDescriptor.setRangeKeys(new Object[]{ADX$Values.ADX, ADX$Values.PDI, ADX$Values.NDI, ADX$Values.HIST});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        this.a();
        this.setMinBars(this.getSettings().getInteger("period", 55) * 4);
        super.onLoad(defaults);
    }

    public void onSettingsUpdated(DataContext dataContext) {
        this.a();
        this.setMinBars(this.getSettings().getInteger("period", 55) * 4);
        super.onSettingsUpdated(dataContext);
    }

    private void a() {
        RuntimeDescriptor runtimeDescriptor = this.getRuntimeDescriptor();
        ArrayList<ADX$Values> arrayList = new ArrayList<ADX$Values>();
        if (this.getSettings().getPath(a).isEnabled()) {
            arrayList.add(ADX$Values.ADX);
        }
        if (this.getSettings().getPath(b).isEnabled()) {
            arrayList.add(ADX$Values.PDI);
        }
        if (this.getSettings().getPath(c).isEnabled()) {
            arrayList.add(ADX$Values.NDI);
        }
        if (this.getSettings().getPath(d).isEnabled()) {
            arrayList.add(ADX$Values.HIST);
        }
        runtimeDescriptor.setRangeKeys(arrayList.toArray());
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        if (dataSeries == null) {
            return;
        }
        Float f2 = dataSeries.getPositiveDM(n2);
        Float f3 = dataSeries.getNegativeDM(n2);
        Float f4 = dataSeries.getTrueRange(n2);
        dataSeries.setFloat(n2, (Object)ADX$Values.PDM, f2);
        dataSeries.setFloat(n2, (Object)ADX$Values.NDM, f3);
        dataSeries.setFloat(n2, (Object)ADX$Values.TR, f4);
        if (n2 <= n3) {
            return;
        }
        Double d2 = dataSeries.smma(n2, n3, (Object)ADX$Values.PDM);
        Double d3 = dataSeries.smma(n2, n3, (Object)ADX$Values.NDM);
        Double d4 = dataSeries.smma(n2, n3, (Object)ADX$Values.TR);
        double d5 = d2 / d4 * 100.0;
        double d6 = d3 / d4 * 100.0;
        double d7 = Math.abs(d2 - d3) / (d2 + d3) * 100.0;
        dataSeries.setDouble(n2, (Object)ADX$Values.DX, Double.valueOf(d7));
        dataSeries.setDouble(n2, (Object)ADX$Values.PDI, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)ADX$Values.NDI, Double.valueOf(d6));
        PathInfo pathInfo = this.getSettings().getPath(d);
        if (pathInfo != null && pathInfo.isEnabled()) {
            dataSeries.setDouble(n2, (Object)ADX$Values.HIST, Double.valueOf(d5 - d6));
        }
        if (n2 < n3 * 2) {
            return;
        }
        Double d8 = dataSeries.smma(n2, n3, (Object)ADX$Values.DX);
        if (d8 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)ADX$Values.ADX, d8);
        dataSeries.setComplete(n2);
    }
}

