/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.Plot;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.general3.b;
import com.motivewave.platform.study.volume.VolumeZoneOsc$Signals;
import com.motivewave.platform.study.volume.VolumeZoneOsc$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_VOL_ZONE_OSC", rb="com.motivewave.platform.study.nls.strings2", label="LBL_VZOSC", name="NAME_VOLUME_ZONE_OSCILLATOR", desc="DESC_VZOSC", helpLink="http://www.motivewave.com/studies/volume_zone_oscillator.htm", requiresVolume=true, signals=false, overlay=false, studyOverlay=true)
public class VolumeZoneOsc
extends Study {
    static final String a = "ReduceWS";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("DISPLAY1", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(b.a, this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor(b.d, this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b.g, this.get("PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b.h, this.get("MA_PERIOD", new Object[0]), 60, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(a, this.get("REDUCE_WHIPSAWS", new Object[0]), Boolean.valueOf(true))});
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b.m, this.get("VZO", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b.n, this.get("MA", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b.o, this.get("ADX_PATH", new Object[0]), defaults.getBlue(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(b.ac, this.get("ADX_UP_COLOR", new Object[0]), defaults.getBlue())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(b.ad, this.get("ADX_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingTab = new SettingTab(this.get("DISPLAY2", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b.v, this.get("VZO", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b.w, this.get("MA", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b.x, this.get("ADX", new Object[0]), defaults.getBlue(), null, false, true, true)});
        SettingGroup settingGroup3 = new SettingGroup(this.get("VZO_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor(b.B, this.get("TOP_GUIDE1", new Object[0]), 60.0, 0.0, 99.0, 1.0, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor(b.E, this.get("TOP_GUIDE2", new Object[0]), 40.0, 0.0, 99.0, 1.0, true);
        guideDescriptor2.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor(b.H, this.get("TOP_GUIDE3", new Object[0]), 15.0, 0.0, 99.0, 1.0, true);
        guideDescriptor3.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        GuideDescriptor guideDescriptor4 = new GuideDescriptor(b.C, this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -99.0, 99.0, 1.0, true);
        guideDescriptor4.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor4});
        GuideDescriptor guideDescriptor5 = new GuideDescriptor(b.D, this.get("BOTTOM_GUIDE1", new Object[0]), -60.0, 0.0, -99.0, 1.0, true);
        guideDescriptor5.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor5});
        GuideDescriptor guideDescriptor6 = new GuideDescriptor(b.G, this.get("BOTTOM_GUIDE2", new Object[0]), -40.0, 0.0, -99.0, 1.0, true);
        guideDescriptor6.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor6});
        GuideDescriptor guideDescriptor7 = new GuideDescriptor(b.J, this.get("BOTTOM_GUIDE3", new Object[0]), -5.0, 0.0, -99.0, 1.0, true);
        guideDescriptor7.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor7});
        settingTab.addGroup(settingGroup3);
        settingTab = new SettingTab(this.get("DISPLAY3", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup4 = new SettingGroup(this.get("ADX_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor8 = new GuideDescriptor(b.K, this.get("TOP_GUIDE", new Object[0]), 26.0, 0.0, 99.0, 1.0, true);
        guideDescriptor8.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor8});
        GuideDescriptor guideDescriptor9 = new GuideDescriptor(b.L, this.get("MIDDLE_GUIDE", new Object[0]), 18.0, 0.0, 99.0, 1.0, true);
        guideDescriptor9.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor9});
        GuideDescriptor guideDescriptor10 = new GuideDescriptor(b.M, this.get("BOTTOM_GUIDE", new Object[0]), 0.0, 0.0, 99.0, 1.0, true);
        guideDescriptor10.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor10});
        settingTab.addGroup(settingGroup4);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor(b.N, this.get("TOP_FILL", new Object[0]), b.C, b.m, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor(b.O, this.get("BOTTOM_FILL", new Object[0]), b.C, b.m, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup5 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.R, this.get("ENTER_LONG", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.S, this.get("EXIT_LONG", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.T, this.get("EXIT_SHORT", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getBlue(), defaults.getLineColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.U, this.get("ENTER_SHORT", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getYellow(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        this.setRuntimeDescriptor(runtimeDescriptor);
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolumeZoneOsc$Values.VZO, this.get("LBL_VZOSC", new Object[0]), new String[]{b.a, b.d, b.g}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolumeZoneOsc$Signals.ENTER_LONG, Enums.ValueType.BOOLEAN, this.get("ENTER_LONG", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolumeZoneOsc$Signals.EXIT_LONG, Enums.ValueType.BOOLEAN, this.get("EXIT_LONG", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolumeZoneOsc$Signals.ENTER_SHORT, Enums.ValueType.BOOLEAN, this.get("ENTER_SHORT", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolumeZoneOsc$Signals.EXIT_SHORT, Enums.ValueType.BOOLEAN, this.get("EXIT_SHORT", new Object[0]), null));
        runtimeDescriptor.getPricePlot().setLabelSettings(new String[]{b.a, b.h});
        runtimeDescriptor.getPricePlot().setLabelPrefix("MA");
        runtimeDescriptor.getPricePlot().declarePath((Object)VolumeZoneOsc$Values.MA, b.n);
        runtimeDescriptor.getPricePlot().declareIndicator((Object)VolumeZoneOsc$Values.MA, b.w);
        runtimeDescriptor.setLabelSettings(new String[]{b.a, b.d, b.g});
        runtimeDescriptor.declarePath((Object)VolumeZoneOsc$Values.VZO, b.m);
        runtimeDescriptor.declareIndicator((Object)VolumeZoneOsc$Values.VZO, b.v);
        runtimeDescriptor.setRangeKeys(new Object[]{VolumeZoneOsc$Values.VZO});
        Plot plot = new Plot();
        runtimeDescriptor.addPlot(b.s, plot);
        plot.setLabelSettings(new String[]{b.a, b.g});
        plot.setLabelPrefix("ADX");
        plot.setTabName("ADX");
        plot.declarePath((Object)VolumeZoneOsc$Values.ADX, b.o);
        plot.declareBars((Object)VolumeZoneOsc$Values.ADX, b.o);
        plot.declareIndicator((Object)VolumeZoneOsc$Values.ADX, b.x);
        plot.declareGuide(b.K);
        plot.declareGuide(b.L);
        plot.declareGuide(b.M);
        plot.setRangeKeys(new Object[]{VolumeZoneOsc$Values.ADX});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger(b.g);
        int n3 = this.getSettings().getInteger(b.h);
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Marker marker;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3;
        int n4 = this.getSettings().getInteger(b.g);
        if (n2 < Math.max(n4, n3 = this.getSettings().getInteger(b.h).intValue())) {
            return;
        }
        Object object = this.getSettings().getInput(b.a, (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod(b.d);
        boolean bl2 = this.getSettings().getBoolean(a);
        Color color = this.getSettings().getColor(b.ac);
        Color color2 = this.getSettings().getColor(b.ad);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getDouble(n2 - 1, object, 0.0);
        long l2 = dataSeries.getVolume(n2);
        double d4 = (long)n.a(d2, d3) * l2;
        dataSeries.setDouble(n2, (Object)VolumeZoneOsc$Values.R, Double.valueOf(d4));
        Double d5 = dataSeries.ma(mAMethod, n2, n3, object);
        Double d6 = dataSeries.ma(mAMethod, n2, n4, (Object)VolumeZoneOsc$Values.R);
        Double d7 = dataSeries.ma(mAMethod, n2, n4, (Object)Enums.BarInput.VOLUME);
        if (d5 == null || d6 == null || d7 == null) {
            return;
        }
        Double d8 = null;
        if (d7 != 0.0) {
            d8 = 100.0 * d6 / d7;
        }
        dataSeries.setDouble(n2, (Object)VolumeZoneOsc$Values.MA, d5);
        dataSeries.setDouble(n2, (Object)VolumeZoneOsc$Values.VZO, d8);
        if (d8 == null) {
            return;
        }
        double d9 = dataSeries.getDouble(n2 - 1, (Object)VolumeZoneOsc$Values.VZO, 0.0);
        Float f2 = dataSeries.getPositiveDM(n2);
        Float f3 = dataSeries.getNegativeDM(n2);
        Float f4 = dataSeries.getTrueRange(n2);
        dataSeries.setFloat(n2, (Object)VolumeZoneOsc$Values.PDM, f2);
        dataSeries.setFloat(n2, (Object)VolumeZoneOsc$Values.NDM, f3);
        dataSeries.setFloat(n2, (Object)VolumeZoneOsc$Values.TR, f4);
        if (n2 <= n4) {
            return;
        }
        Double d10 = dataSeries.smma(n2, n4, (Object)VolumeZoneOsc$Values.PDM);
        Double d11 = dataSeries.smma(n2, n4, (Object)VolumeZoneOsc$Values.NDM);
        Double d12 = dataSeries.smma(n2, n4, (Object)VolumeZoneOsc$Values.TR);
        if (d10 == null || d11 == null || d12 == null) {
            return;
        }
        double d13 = d10 / d12 * 100.0;
        double d14 = d11 / d12 * 100.0;
        double d15 = Math.abs(d10 - d11) / (d10 + d11) * 100.0;
        dataSeries.setDouble(n2, (Object)VolumeZoneOsc$Values.DX, Double.valueOf(d15));
        dataSeries.setDouble(n2, (Object)VolumeZoneOsc$Values.PDI, Double.valueOf(d13));
        dataSeries.setDouble(n2, (Object)VolumeZoneOsc$Values.NDI, Double.valueOf(d14));
        Double d16 = dataSeries.smma(n2, n4, (Object)VolumeZoneOsc$Values.DX);
        if (d16 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)VolumeZoneOsc$Values.ADX, d16);
        double d17 = this.getSettings().getGuide(b.L).getValue();
        if (d16 > d17) {
            dataSeries.setBarColor(n2, (Object)VolumeZoneOsc$Values.ADX, color);
        } else {
            dataSeries.setBarColor(n2, (Object)VolumeZoneOsc$Values.ADX, color2);
        }
        double d18 = this.getSettings().getGuide(b.B).getValue();
        double d19 = this.getSettings().getGuide(b.E).getValue();
        double d20 = this.getSettings().getGuide(b.H).getValue();
        double d21 = this.getSettings().getGuide(b.C).getValue();
        double d22 = this.getSettings().getGuide(b.D).getValue();
        double d23 = this.getSettings().getGuide(b.G).getValue();
        double d24 = this.getSettings().getGuide(b.J).getValue();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (d2 > d5 && d16 > d17) {
            if (bl2) {
                boolean bl7 = bl3 = d9 < d23 && d8 > d23 || d9 < d20 && d8 > d20;
            }
            if (!bl2) {
                bl3 = d9 < d23 && d8 > d23 || d9 < d21 && d8 > d21;
            }
            boolean bl8 = bl4 = d9 > d18 && d8 < d9 || d9 > d19 && d8 < d19 || d2 < d5 && d8 < d21;
        }
        if (d2 < d5 && d16 > d17) {
            if (bl2) {
                boolean bl9 = bl5 = d9 > d19 && d8 < d19 || d9 > d24 && d8 < d24;
            }
            if (!bl2) {
                bl5 = d9 > d19 && d8 < d19 || d9 > d21 && d8 < d21;
            }
            boolean bl10 = bl6 = d8 < d22 && d8 > d9 || d9 < d23 && d8 > d23 || d2 > d5 && d9 < d21 && d8 > d21;
        }
        if (d16 < d17) {
            bl3 = d9 < d23 && d8 > d23 || d9 < d20 && d8 > d20;
            bl4 = d9 < d19 && d8 > d19 && bl4 || d9 > d24 && d8 < d24;
            boolean bl11 = bl5 = d9 > d19 && d8 < d19 || d9 > d24 && d8 < d24;
            if (d9 > d23 && d8 < d23) {
                if (bl2) {
                    boolean bl12 = bl6 = d9 < d23 && d8 > d23 || d9 < d20 && d8 > d20;
                }
                if (!bl2) {
                    boolean bl13 = bl6 = d9 < d23 && d8 > d23 || d9 < d21 && d8 > d21;
                }
            }
            if (d8 > d23) {
                boolean bl14 = bl6 = d9 < d20 && d8 > d20;
            }
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d8.doubleValue());
            markerInfo = this.getSettings().getMarker(b.R);
            marker = new Marker(coordinate, Enums.Position.BOTTOM, markerInfo);
            marker.setTextValue(this.get("ENTER_LONG", new Object[0]));
            marker.setTextPosition(Enums.Position.BOTTOM);
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)marker);
            }
            dataContext.signal(n2, (Object)VolumeZoneOsc$Signals.ENTER_LONG, this.get("ENTER_LONG_PRICE_VZO", new Object[]{Util.round((double)d2, (int)3), Util.round((double)d8, (int)3)}), (Object)d2);
        }
        if (bl4) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d8.doubleValue());
            markerInfo = this.getSettings().getMarker(b.S);
            marker = new Marker(coordinate, Enums.Position.TOP, markerInfo);
            marker.setTextValue(this.get("EXIT_LONG", new Object[0]));
            marker.setTextPosition(Enums.Position.TOP);
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)marker);
            }
            dataContext.signal(n2, (Object)VolumeZoneOsc$Signals.EXIT_LONG, this.get("EXIT_LONG_PRICE_VZO", new Object[]{Util.round((double)d2, (int)3), Util.round((double)d8, (int)3)}), (Object)d2);
        }
        if (bl5) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d8.doubleValue());
            markerInfo = this.getSettings().getMarker(b.U);
            marker = new Marker(coordinate, Enums.Position.TOP, markerInfo);
            marker.setTextValue(this.get("ENTER_SHORT", new Object[0]));
            marker.setTextPosition(Enums.Position.TOP);
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)marker);
            }
            dataContext.signal(n2, (Object)VolumeZoneOsc$Signals.ENTER_SHORT, this.get("ENTER_SHORT_PRICE_VZO", new Object[]{Util.round((double)d2, (int)3), Util.round((double)d8, (int)3)}), (Object)d2);
        }
        if (bl6) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d8.doubleValue());
            markerInfo = this.getSettings().getMarker(b.T);
            marker = new Marker(coordinate, Enums.Position.BOTTOM, markerInfo);
            marker.setTextValue(this.get("EXIT_SHORT", new Object[0]));
            marker.setTextPosition(Enums.Position.BOTTOM);
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)marker);
            }
            dataContext.signal(n2, (Object)VolumeZoneOsc$Signals.EXIT_SHORT, this.get("EXIT_SHORT_PRICE_VZO", new Object[]{Util.round((double)d2, (int)3), Util.round((double)d8, (int)3)}), (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

