/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.VolumePriceTrend$Values;

@StudyHeader(namespace="com.motivewave", id="ID_VLPT", rb="com.motivewave.platform.study.nls.strings2", name="NAME_VOLUME_PRICE_TREND", label="LBL_VLPT", desc="DESC_VLPT", helpLink="http://www.motivewave.com/studies/volume_price_trend.htm", requiresVolume=true, signals=false, overlay=false, studyOverlay=true)
public class VolumePriceTrend
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_VLPT", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolumePriceTrend$Values.VLPT, this.get("LBL_VLPT", new Object[0]), new String[]{"input"}));
        runtimeDescriptor.declarePath((Object)VolumePriceTrend$Values.VLPT, "line");
        runtimeDescriptor.declareIndicator((Object)VolumePriceTrend$Values.VLPT, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{VolumePriceTrend$Values.VLPT});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
        this.setMinBars(20);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getVolume(n2);
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        double d4 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d5 = dataSeries.getDouble(n2 - 1, (Object)VolumePriceTrend$Values.VLPT, 0.0);
        double d6 = d5 + d2 * ((d3 - d4) / d4);
        dataSeries.setDouble(n2, (Object)VolumePriceTrend$Values.VLPT, Double.valueOf(d6));
        dataSeries.setComplete(n2);
    }
}

