/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.VolumeAccumPerCent$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_VAPC", rb="com.motivewave.platform.study.nls.strings2", name="NAME_VOLUME_ACCUM_PERCENT", label="LBL_VAPC", desc="DESC_VAPC", helpLink="http://www.motivewave.com/studies/volume_accum_percent.htm", requiresVolume=true, signals=false, overlay=false, studyOverlay=true)
public class VolumeAccumPerCent
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 21, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9999.1, 9999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolumeAccumPerCent$Values.VAPC, this.get("LBL_VAPC", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declareBars((Object)VolumeAccumPerCent$Values.VAPC);
        runtimeDescriptor.declareIndicator((Object)VolumeAccumPerCent$Values.VAPC, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{VolumeAccumPerCent$Values.VAPC});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getHigh(n2);
        double d3 = dataSeries.getLow(n2);
        double d4 = dataSeries.getClose(n2);
        double d5 = dataSeries.getVolume(n2);
        double d6 = 0.0;
        double d7 = 0.0;
        if (d2 - d3 != 0.0) {
            d6 = (d4 - d3 - (d2 - d4)) / (d2 - d3);
        }
        double d8 = d5 * d6;
        dataSeries.setDouble(n2, (Object)VolumeAccumPerCent$Values.TVA, Double.valueOf(d8));
        if (n2 < n3) {
            return;
        }
        double d9 = dataSeries.sum(n2, n3, (Object)Enums.BarInput.VOLUME);
        double d10 = dataSeries.sum(n2, n3, (Object)VolumeAccumPerCent$Values.TVA);
        if (d9 != 0.0) {
            d7 = d10 / d9 * 100.0;
        }
        dataSeries.setDouble(n2, (Object)VolumeAccumPerCent$Values.VAPC, Double.valueOf(d7));
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d11 = guideInfo.getValue();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        if (d7 > d11) {
            dataSeries.setBarColor(n2, (Object)VolumeAccumPerCent$Values.VAPC, color);
        } else {
            dataSeries.setBarColor(n2, (Object)VolumeAccumPerCent$Values.VAPC, color2);
        }
        dataSeries.setComplete(n2);
    }
}

