/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.Volume$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="VOLUME", rb="com.motivewave.platform.study.nls.strings", name="TITLE_VOLUME", menu="MENU_VOLUME", desc="DESC_VOLUME", overlay=false, requiresVolume=true, requiresBarUpdates=true)
public class Volume
extends Study {
    static final String a = "volumeInd";
    static final String b = "vmaInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_VOLUME", new Object[0]));
        settingTab.addGroup(settingGroup);
        PathDescriptor pathDescriptor = new PathDescriptor("bar", this.get("LBL_VOLUME_BARS", new Object[0]), defaults.getBarColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setSupportsDisable(false);
        pathDescriptor.setColorPolicies(new Enums.ColorPolicy[]{Enums.ColorPolicy.PRICE_BAR, Enums.ColorPolicy.SOLID, Enums.ColorPolicy.HIGHER_LOWER, Enums.ColorPolicy.GRADIENT});
        pathDescriptor.setColorPolicy(Enums.ColorPolicy.PRICE_BAR);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup = new SettingGroup(this.get("LBL_MOVING_AVERAGE", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        PathDescriptor pathDescriptor2 = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), new Color(225, 102, 0), 1.0f, null, true, false, true);
        pathDescriptor2.setShadeType(Enums.ShadeType.BELOW);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor2});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Volume$Values.VOLUME, this.get("LBL_VOLUME", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Volume$Values.VMA, this.get("LBL_VMA", new Object[0]), new String[]{"method", "period"}));
        runtimeDescriptor.declarePath((Object)Volume$Values.VOLUME, "bar");
        runtimeDescriptor.declarePath((Object)Volume$Values.VMA, "line");
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.setBottomInsetPixels(0);
        runtimeDescriptor.setRangeKeys(new Object[]{Volume$Values.VOLUME});
        runtimeDescriptor.setMinTopValue(Integer.valueOf(10));
        runtimeDescriptor.declareIndicator((Object)Volume$Values.VOLUME, a);
        runtimeDescriptor.declareIndicator((Object)Volume$Values.VMA, b);
        runtimeDescriptor.setMinTick(Double.valueOf(1.0));
        runtimeDescriptor.setTopInsetPixels(5);
        runtimeDescriptor.setBottomInsetPixels(0);
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        float f2 = dataSeries.getVolumeAsFloat(n2);
        dataSeries.setFloat(n2, (Object)Volume$Values.VOLUME, Float.valueOf(f2));
        PathInfo pathInfo = this.getSettings().getPath("line");
        if (pathInfo == null || !pathInfo.isEnabled()) {
            return;
        }
        int n3 = this.getSettings().getInteger("period", 20);
        if (n2 < n3) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        dataSeries.setDouble(n2, (Object)Volume$Values.VMA, dataSeries.ma(mAMethod, n2, n3, (Object)Volume$Values.VOLUME));
    }
}

