/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.PVO$Values;

@StudyHeader(namespace="com.motivewave", id="PVO", rb="com.motivewave.platform.study.nls.strings", name="TITLE_PVO", label="LBL_PVO", desc="DESC_PVO", menu="MENU_VOLUME", overlay=false, requiresVolume=true, helpLink="http://www.motivewave.com/studies/percentage_volume_oscillator.htm")
public class PVO
extends Study {
    static final String a = "histInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("signalMethod", this.get("LBL_SIGNAL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD1", new Object[0]), 12, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_PERIOD2", new Object[0]), 26, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 9, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_PVO_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("signalLine", this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        PathDescriptor pathDescriptor = new PathDescriptor("bar", this.get("LBL_BAR_COLOR", new Object[0]), defaults.getBarColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setColorPolicies(Enums.ColorPolicy.values());
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_PVO_IND", new Object[0]), null, null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("signalInd", this.get("LBL_SIGNAL_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("LBL_HIST_IND", new Object[0]), defaults.getBarColor(), null, false, false, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", "period2", "signalPeriod"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PVO$Values.PVO, this.get("LBL_PVO", new Object[0]), new String[]{"period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PVO$Values.SIGNAL, this.get("LBL_PVO_SIGNAL", new Object[0]), new String[]{"signalPeriod"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PVO$Values.HIST, this.get("LBL_PVO_HIST", new Object[0]), new String[]{"period", "period2", "signalPeriod"}));
        runtimeDescriptor.declarePath((Object)PVO$Values.PVO, "line");
        runtimeDescriptor.declarePath((Object)PVO$Values.SIGNAL, "signalLine");
        runtimeDescriptor.declarePath((Object)PVO$Values.HIST, "bar");
        runtimeDescriptor.declareIndicator((Object)PVO$Values.PVO, "ind");
        runtimeDescriptor.declareIndicator((Object)PVO$Values.SIGNAL, "signalInd");
        runtimeDescriptor.declareIndicator((Object)PVO$Values.HIST, a);
        runtimeDescriptor.setRangeKeys(new Object[]{PVO$Values.PVO, PVO$Values.SIGNAL, PVO$Values.HIST});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger("period");
        int n5 = Util.max((int)n4, (int)(n3 = this.getSettings().getInteger("period2").intValue()));
        if (n2 <= n5) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = null;
        Double d3 = null;
        d2 = dataSeries.ma(mAMethod, n2, n4, (Object)Enums.BarInput.VOLUME);
        d3 = dataSeries.ma(mAMethod, n2, n3, (Object)Enums.BarInput.VOLUME);
        if (d2 == null || d3 == null) {
            return;
        }
        double d4 = (d2 - d3) / d3 * 100.0;
        dataSeries.setDouble(n2, (Object)PVO$Values.PVO, Double.valueOf(d4));
        int n6 = this.getSettings().getInteger("signalPeriod");
        if (n2 <= n5 + n6) {
            return;
        }
        Double d5 = dataSeries.ma(this.getSettings().getMAMethod("signalMethod"), n2, n6, (Object)PVO$Values.PVO);
        dataSeries.setDouble(n2, (Object)PVO$Values.SIGNAL, d5);
        if (d5 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)PVO$Values.HIST, Double.valueOf(d4 - d5));
        dataSeries.setComplete(n2);
    }
}

