/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.OnBalanceVolume$Values;

@StudyHeader(namespace="com.motivewave", id="OBV", rb="com.motivewave.platform.study.nls.strings", name="TITLE_OBV", tabName="TAB_OBV", desc="DESC_OBV", menu="MENU_VOLUME", overlay=false, requiresVolume=true, helpLink="http://www.motivewave.com/studies/on_balance_volume.htm")
public class OnBalanceVolume
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)OnBalanceVolume$Values.OBV, this.get("VAL_OBV", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)OnBalanceVolume$Values.OBV, "line");
        runtimeDescriptor.declareIndicator((Object)OnBalanceVolume$Values.OBV, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{OnBalanceVolume$Values.OBV});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2 - 1, (Object)OnBalanceVolume$Values.OBV);
        if (d2 == null) {
            d2 = 0.0;
        }
        double d3 = d2;
        if (dataSeries.getClose(n2) > dataSeries.getClose(n2 - 1)) {
            d3 = d2 + (double)dataSeries.getVolume(n2);
        } else if (dataSeries.getClose(n2) < dataSeries.getClose(n2 - 1)) {
            d3 = d2 - (double)dataSeries.getVolume(n2);
        }
        dataSeries.setDouble(n2, (Object)OnBalanceVolume$Values.OBV, Double.valueOf(d3));
        dataSeries.setComplete(n2);
    }
}

