/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.volume.NegVolDisparityInd$Signals;
import com.motivewave.platform.study.volume.NegVolDisparityInd$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_NVDI", rb="com.motivewave.platform.study.nls.strings2", desc="DESC_NVDI", label="LBL_NVDI", name="NAME_NEGATIVE_VOLUME_DISPARITY_INDICATOR", helpLink="http://www.motivewave.com/studies/negative_volume_disparity_indicator.htm", requiresVolume=true, overlay=false, signals=true, studyOverlay=true)
public class NegVolDisparityInd
extends Study {
    static final String a = "StdDev";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 33, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 4, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("STD_DEV", new Object[0]), 2.0, 0.1, 99.1, 0.1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("NVDI", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MA", new Object[0]), defaults.getRed(), 1.0f, null, true, true, false)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("NVDI", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MA", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 1.1, 0.0, 9.001, 0.001, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 1.0, 0.0, 9.001, 0.001, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 0.9, 0.0, 9.001, 0.001, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "method", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NegVolDisparityInd$Values.NVDI, this.get("LBL_NVDI", new Object[0]), new String[]{"input", "period", "period2", "method", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NegVolDisparityInd$Values.MA, this.get("MA", new Object[0]), new String[]{"method", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NegVolDisparityInd$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NegVolDisparityInd$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)NegVolDisparityInd$Values.NVDI, "line");
        runtimeDescriptor.declarePath((Object)NegVolDisparityInd$Values.MA, "line2");
        runtimeDescriptor.declareIndicator((Object)NegVolDisparityInd$Values.NVDI, "ind");
        runtimeDescriptor.declareIndicator((Object)NegVolDisparityInd$Values.MA, "ind2");
        runtimeDescriptor.declareSignal((Object)NegVolDisparityInd$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)NegVolDisparityInd$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{NegVolDisparityInd$Values.NVDI, NegVolDisparityInd$Values.MA});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 * 2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < n3) {
            return;
        }
        double d2 = this.getSettings().getDouble(a);
        Object object = this.getSettings().getInput("input");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        double d4 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d5 = dataSeries.getVolume(n2);
        double d6 = dataSeries.getVolume(n2 - 1);
        double[] dArray = n.a(dataSeries, n2, n3, d2, d2, object);
        double d7 = dArray[0] - dArray[1];
        double d8 = 0.0;
        if (d7 != 0.0) {
            d8 = (d3 - dArray[1]) / d7;
        }
        double d9 = dataSeries.getDouble(n2 - 1, (Object)NegVolDisparityInd$Values.NEG_VOL, 100.0);
        if (d5 < d6) {
            d9 += (d3 - d4) / d4 * 100.0;
        }
        dataSeries.setDouble(n2, (Object)NegVolDisparityInd$Values.NEG_VOL, Double.valueOf(d9));
        if (n2 < n3 * 2) {
            return;
        }
        double[] dArray2 = n.a(dataSeries, n2, n3, d2, d2, (Object)NegVolDisparityInd$Values.NEG_VOL);
        double d10 = dArray2[0] - dArray2[1];
        double d11 = 0.0;
        if (d10 != 0.0) {
            d11 = (d9 - dArray2[1]) / d10;
        }
        double d12 = (1.0 + d8) / (1.0 + d11);
        dataSeries.setDouble(n2, (Object)NegVolDisparityInd$Values.NVDI, Double.valueOf(d12));
        if (n2 < n3 * 2 + n4) {
            return;
        }
        Double d13 = dataSeries.ma(mAMethod, n2, n4, (Object)NegVolDisparityInd$Values.NVDI);
        if (d13 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)NegVolDisparityInd$Values.MA, d13);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d14 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d15 = guideInfo2.getValue();
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)NegVolDisparityInd$Values.NVDI, (Object)NegVolDisparityInd$Values.MA) && d13 > d14 && d12 > this.a;
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)NegVolDisparityInd$Values.NVDI, (Object)NegVolDisparityInd$Values.MA) && d13 < d15 && d12 < this.b;
        dataSeries.setBoolean(n2, (Object)NegVolDisparityInd$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)NegVolDisparityInd$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d12;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_NVDI", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)NegVolDisparityInd$Signals.SELL, string, (Object)d3);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d12;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_NVDI", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)NegVolDisparityInd$Signals.BUY, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

