/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.MultVoteObv$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_MVOBV", rb="com.motivewave.platform.study.nls.strings2", name="NAME_MULTI_VOTE_OBV", label="LBL_MVOBV", desc="DESC_MVOBV", helpLink="http://www.motivewave.com/studies/multi_vote_onbalance_volume.htm", overlay=false, requiresVolume=true, studyOverlay=true)
public class MultVoteObv
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("COLORS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.1, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup2.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[0]);
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MultVoteObv$Values.MVO, this.get("LBL_MVOBV", new Object[0]), new String[0]));
        runtimeDescriptor.declareBars((Object)MultVoteObv$Values.MVO);
        runtimeDescriptor.declareIndicator((Object)MultVoteObv$Values.MVO, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{MultVoteObv$Values.MVO});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        this.setMinBars(20);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getClose(n2);
        double d3 = dataSeries.getClose(n2 - 1);
        double d4 = dataSeries.getLow(n2);
        double d5 = dataSeries.getLow(n2 - 1);
        double d6 = dataSeries.getHigh(n2);
        double d7 = dataSeries.getHigh(n2 - 1);
        double d8 = (double)dataSeries.getVolume(n2) / 1000000.0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (d6 > d7) {
            n3 = 1;
        }
        if (d6 < d7) {
            n3 = -1;
        }
        if (d4 > d5) {
            n4 = 1;
        }
        if (d4 < d5) {
            n4 = -1;
        }
        if (d2 > d3) {
            n5 = 1;
        }
        if (d2 < d3) {
            n5 = -1;
        }
        int n6 = n3 + n4 + n5;
        double d9 = dataSeries.getDouble(n2, (Object)MultVoteObv$Values.MVO, d8);
        double d10 = d9 + d8 * (double)n6;
        dataSeries.setDouble(n2, (Object)MultVoteObv$Values.MVO, Double.valueOf(d10));
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d11 = guideInfo.getValue();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        if (d10 > d11) {
            dataSeries.setBarColor(n2, (Object)MultVoteObv$Values.MVO, color);
        } else {
            dataSeries.setBarColor(n2, (Object)MultVoteObv$Values.MVO, color2);
        }
        dataSeries.setComplete(n2);
    }
}

