/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.PriceData;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.TickOperation;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PriceBarDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.DeltaVolume$Values;
import com.motivewave.platform.study.volume.m;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="DELTAV", rb="com.motivewave.platform.study.nls.strings", name="TITLE_DELTAV", label="LBL_DELTAV", desc="DESC_DELTAV", menu="MENU_VOLUME", overlay=false, studyOverlay=true, requiresBarUpdates=true, helpLink="http://www.motivewave.com/studies/delta_volume.htm")
public class DeltaVolume
extends Study {
    static final String a = "count";
    static final String b = "showAll";
    static final String c = "rthData";
    private boolean a = false;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("TAB_INPUTS", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_DELTA_COUNT", new Object[0]), 20, 1, 9999, 1), new BooleanDescriptor(b, this.get("LBL_SHOW_ALL", new Object[0]), Boolean.valueOf(false), false)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(c, this.get("LBL_RTH_DATA", new Object[0]), Boolean.valueOf(false))});
        settingGroup = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new PriceBarDescriptor("priceBar", this.get("LBL_BAR_TYPE", new Object[0]), null, Enums.BarInput.CLOSE, true, false)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(false, b, new String[]{a}));
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DeltaVolume$Values.OPEN, Enums.ValueType.DOUBLE, this.get("LBL_DELTA_OPEN", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DeltaVolume$Values.HIGH, Enums.ValueType.DOUBLE, this.get("LBL_DELTA_HIGH", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DeltaVolume$Values.LOW, Enums.ValueType.DOUBLE, this.get("LBL_DELTA_LOW", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DeltaVolume$Values.CLOSE, Enums.ValueType.DOUBLE, this.get("LBL_DELTA_CLOSE", new Object[0]), null));
        runtimeDescriptor.declarePriceBar((Object)DeltaVolume$Values.PRICE_BAR, "priceBar");
        runtimeDescriptor.declareIndicator((Object)DeltaVolume$Values.CLOSE, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{DeltaVolume$Values.HIGH, DeltaVolume$Values.LOW});
        runtimeDescriptor.setMinTick(Double.valueOf(1.0));
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void clearState() {
        this.a = false;
        super.clearState();
    }

    protected void calculateValues(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        boolean bl2 = false;
        for (int i2 = dataSeries.size() - 1; i2 >= 0; --i2) {
            if (!dataSeries.isComplete(i2)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            Util.schedule(() -> this.a(dataContext));
        } else {
            this.a(dataContext);
        }
    }

    private void a(DataContext dataContext) {
        int n2;
        int n3;
        this.a = true;
        boolean bl2 = this.getSettings().getBoolean(b, false);
        int n4 = this.getSettings().getInteger(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        int n5 = n3 = bl2 ? 0 : dataSeries.size() - n4;
        for (n2 = dataSeries.size() - 1; n2 >= n3; --n2) {
            if (!dataSeries.isComplete(n2)) continue;
            n5 = n2 + 1;
            break;
        }
        if (!bl2) {
            for (n2 = dataSeries.size() - n4 - 1; n2 >= 0 && dataSeries.isComplete(n2); --n2) {
                dataSeries.setValue(n2, (Object)DeltaVolume$Values.PRICE_BAR, null);
                dataSeries.setFloat(n2, (Object)DeltaVolume$Values.OPEN, Float.valueOf(0.0f));
                dataSeries.setFloat(n2, (Object)DeltaVolume$Values.HIGH, Float.valueOf(0.0f));
                dataSeries.setFloat(n2, (Object)DeltaVolume$Values.LOW, Float.valueOf(0.0f));
                dataSeries.setFloat(n2, (Object)DeltaVolume$Values.CLOSE, Float.valueOf(0.0f));
            }
        }
        Instrument instrument = dataSeries.getInstrument();
        long l2 = Util.getStartOfBar((long)dataSeries.getStartTime(n5), (long)dataSeries.getEndTime(n5), (Instrument)instrument, (BarSize)dataSeries.getBarSize(), (boolean)dataContext.isRTH());
        m m2 = new m(this, n5, dataSeries, dataContext.isRTH());
        instrument.forEachTick(l2, dataContext.getCurrentTime() + 300000L, dataContext.isRTH(), (TickOperation)m2);
        m2.a();
        this.a = false;
    }

    public void onBarUpdate(DataContext dataContext) {
    }

    public void onTick(DataContext dataContext, Tick tick) {
        Settings settings = this.getSettings();
        Instrument instrument = dataContext.getInstrument();
        boolean bl2 = settings.getBoolean(c, false);
        if (this.a || !instrument.isInsideTradingHours(tick.getTime(), bl2)) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        float f2 = dataSeries.getFloat((Object)DeltaVolume$Values.CLOSE, 0.0f).floatValue();
        float f3 = dataSeries.getFloat((Object)DeltaVolume$Values.OPEN, 0.0f).floatValue();
        float f4 = dataSeries.getFloat((Object)DeltaVolume$Values.HIGH, 0.0f).floatValue();
        float f5 = dataSeries.getFloat((Object)DeltaVolume$Values.LOW, 0.0f).floatValue();
        double d2 = Util.toDouble((Object)dataSeries.highestVisible((Object)DeltaVolume$Values.HIGH));
        double d3 = Util.toDouble((Object)dataSeries.lowestVisible((Object)DeltaVolume$Values.LOW));
        float f6 = tick.getVolumeAsFloat();
        if (f6 <= 0.0f) {
            f6 = 1.0f;
        }
        f2 = tick.isAskTick() ? (f2 += f6) : (f2 -= f6);
        float f7 = f4;
        float f8 = f5;
        if (f4 < f2) {
            f4 = f2;
        }
        if (f5 > f2) {
            f5 = f2;
        }
        dataSeries.setValue((Object)DeltaVolume$Values.PRICE_BAR, (Object)new PriceData(f3, f4, f5, f2));
        dataSeries.setFloat((Object)DeltaVolume$Values.OPEN, Float.valueOf(f3));
        dataSeries.setFloat((Object)DeltaVolume$Values.HIGH, Float.valueOf(f4));
        dataSeries.setFloat((Object)DeltaVolume$Values.LOW, Float.valueOf(f5));
        dataSeries.setFloat((Object)DeltaVolume$Values.CLOSE, Float.valueOf(f2));
        if (f4 > f7 && (double)f4 > d2 || f5 < f8 && (double)f5 < d3) {
            this.notifyRangeUpdated();
        }
    }
}

