/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.PriceData;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.TickOperation;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.PriceBarDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.CumulativeDelta$Values;
import com.motivewave.platform.study.volume.c;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="CDELTA", rb="com.motivewave.platform.study.nls.strings", name="TITLE_CDELTA", label="LBL_CDELTA", desc="DESC_CDELTA", menu="MENU_VOLUME", overlay=false, studyOverlay=true, requiresBarUpdates=true, helpLink="http://www.motivewave.com/studies/cumulative_delta.htm")
public class CumulativeDelta
extends Study {
    static final String a = "rthData";
    private boolean a = false;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(a, this.get("LBL_RESET_RTH", new Object[0]), Boolean.valueOf(true))});
        settingGroup.addRow(new SettingDescriptor[]{new PriceBarDescriptor("priceBar", this.get("LBL_BAR_TYPE", new Object[0]), null, Enums.BarInput.CLOSE, true, false)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CumulativeDelta$Values.OPEN, Enums.ValueType.INTEGER, this.get("LBL_CD_OPEN", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CumulativeDelta$Values.HIGH, Enums.ValueType.INTEGER, this.get("LBL_CD_HIGH", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CumulativeDelta$Values.LOW, Enums.ValueType.INTEGER, this.get("LBL_CD_LOW", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CumulativeDelta$Values.CLOSE, Enums.ValueType.INTEGER, this.get("LBL_CD_CLOSE", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CumulativeDelta$Values.DELTA, Enums.ValueType.INTEGER, this.get("LBL_CD_DELTA", new Object[0]), null));
        runtimeDescriptor.declarePriceBar((Object)CumulativeDelta$Values.PRICE_BAR, "priceBar");
        runtimeDescriptor.declareIndicator((Object)CumulativeDelta$Values.CLOSE, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{CumulativeDelta$Values.HIGH, CumulativeDelta$Values.LOW});
        runtimeDescriptor.setMinTick(Double.valueOf(1.0));
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public Long getMinStartTime(DataContext dataContext) {
        if (dataContext.getDataSeries() == null || dataContext.getDataSeries().size() <= 0) {
            return dataContext.getCurrentTime() - 172800000L;
        }
        return this.a(dataContext.getDataSeries(), 0);
    }

    private long a(DataSeries dataSeries, int n2) {
        Instrument instrument = dataSeries.getInstrument();
        long l2 = instrument.getStartOfDay((dataSeries.getStartTime(n2) + dataSeries.getEndTime(n2)) / 2L, this.getSettings().getBoolean(a, true));
        return l2;
    }

    protected void calculateValues(DataContext dataContext) {
        long l2;
        this.a = true;
        DataSeries dataSeries = dataContext.getDataSeries();
        Instrument instrument = dataSeries.getInstrument();
        if (dataSeries.isComplete(0)) {
            for (int i2 = dataSeries.size() - 1; i2 > 0; --i2) {
                if (!dataSeries.isComplete(i2)) continue;
                int n2 = i2 + 1;
                Util.schedule(() -> this.a(dataContext, n2));
                return;
            }
        }
        for (l2 = this.a(dataSeries, 0); l2 > dataSeries.getStartTime(0); l2 -= 86400000L) {
        }
        long l3 = l2 + 86400000L;
        c c2 = new c(this, l2, l3, dataSeries, this.getSettings().getBoolean(a));
        instrument.forEachTick(l2, dataSeries.getEndTime(), dataContext.isRTH(), (TickOperation)c2);
        c2.a();
        this.a = false;
    }

    private void a(DataContext dataContext, int n2) {
        this.a = true;
        DataSeries dataSeries = dataContext.getDataSeries();
        Instrument instrument = dataSeries.getInstrument();
        long l2 = this.a(dataSeries, n2);
        long l3 = l2 + 86400000L;
        long l4 = l2;
        c c2 = new c(this, l2, l3, dataSeries, this.getSettings().getBoolean(a));
        if (n2 > 0) {
            c2.d = c2.b = (c2.a = dataSeries.getFloat(n2 - 1, (Object)CumulativeDelta$Values.CLOSE, 0.0f));
            c2.c = c2.b;
            c2.a = n2;
            c2.c = dataSeries.getEndTime(n2);
            l4 = dataSeries.getStartTime(n2);
        }
        instrument.forEachTick(l4, dataSeries.getEndTime(), dataContext.isRTH(), (TickOperation)c2);
        c2.a();
        this.notifyRangeUpdated();
        this.a = false;
    }

    public void onTick(DataContext dataContext, Tick tick) {
        float f2;
        if (this.a) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        if (tick.getTime() >= dataSeries.getEndTime() && dataSeries.getBarSize().isFixedSize()) {
            return;
        }
        int n2 = dataSeries.size() - 2;
        if (n2 < 0) {
            return;
        }
        float f3 = dataSeries.getFloat((Object)CumulativeDelta$Values.CLOSE, 0.0f).floatValue();
        float f4 = dataSeries.getFloat((Object)CumulativeDelta$Values.OPEN, 0.0f).floatValue();
        float f5 = dataSeries.getFloat((Object)CumulativeDelta$Values.HIGH, 0.0f).floatValue();
        float f6 = dataSeries.getFloat((Object)CumulativeDelta$Values.LOW, 0.0f).floatValue();
        if (dataSeries.getValue((Object)CumulativeDelta$Values.OPEN) == null) {
            if (dataSeries.getValue(n2, (Object)CumulativeDelta$Values.OPEN) == null) {
                return;
            }
            long l2 = this.a(dataSeries, n2);
            long l3 = l2 + 86400000L;
            f3 = dataSeries.getStartTime() >= l3 ? 0.0f : dataSeries.getFloat(n2, (Object)CumulativeDelta$Values.CLOSE, 0.0f);
            f4 = f3;
            f5 = f6 = f3;
        }
        if ((f2 = tick.getVolumeAsFloat()) <= 0.0f) {
            f2 = 1.0f;
        }
        f3 = tick.isAskTick() ? (f3 += f2) : (f3 -= f2);
        if (f5 < f3) {
            f5 = f3;
        }
        if (f6 > f3) {
            f6 = f3;
        }
        dataSeries.setValue((Object)CumulativeDelta$Values.PRICE_BAR, (Object)new PriceData(f4, f5, f6, f3));
        dataSeries.setFloat((Object)CumulativeDelta$Values.OPEN, Float.valueOf(f4));
        dataSeries.setFloat((Object)CumulativeDelta$Values.HIGH, Float.valueOf(f5));
        dataSeries.setFloat((Object)CumulativeDelta$Values.LOW, Float.valueOf(f6));
        dataSeries.setFloat((Object)CumulativeDelta$Values.CLOSE, Float.valueOf(f3));
        dataSeries.setFloat((Object)CumulativeDelta$Values.DELTA, Float.valueOf(f3 - f4));
    }
}

