/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.TickOperation;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.BidAskVolume$Signals;
import com.motivewave.platform.study.volume.BidAskVolume$Values;
import com.motivewave.platform.study.volume.b;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="BIDASKVOL", rb="com.motivewave.platform.study.nls.strings", name="TITLE_BIDASK_VOLUME", label="LBL_BIDASK_VOL", desc="DESC_BIDASK_VOL", menu="MENU_VOLUME", overlay=false, studyOverlay=true, signals=true, requiresBarUpdates=true, helpLink="http://www.motivewave.com/studies/bid_ask_volume.htm")
public class BidAskVolume
extends Study {
    static final String a = "count";
    static final String b = "showAll";
    static final String c = "rthData";
    static final String d = "askPath";
    static final String e = "bidPath";
    static final String f = "askInd";
    static final String g = "bidInd";
    private boolean a = false;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("TAB_INPUTS", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_BAR_COUNT", new Object[0]), 20, 1, 9999, 1), new BooleanDescriptor(b, this.get("LBL_SHOW_ALL", new Object[0]), Boolean.valueOf(false), false)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(c, this.get("LBL_RTH_DATA", new Object[0]), Boolean.valueOf(false))});
        settingGroup = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor(d, this.get("LBL_ASK_VOLUME", new Object[0]), defaults.getGreenLine(), 1.0f, null, true, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor(e, this.get("LBL_BID_VOLUME", new Object[0]), defaults.getRedLine(), 1.0f, null, true, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("LBL_ASK_INDICATOR", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("LBL_BID_INDICATOR", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(false, b, new String[]{a}));
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.declarePath((Object)BidAskVolume$Values.ASK_VOL, d);
        runtimeDescriptor.declarePath((Object)BidAskVolume$Values.BID_VOL, e);
        runtimeDescriptor.declareIndicator((Object)BidAskVolume$Values.ASK_VOL, f);
        runtimeDescriptor.declareIndicator((Object)BidAskVolume$Values.BID_VOL, g);
        runtimeDescriptor.setRangeKeys(new Object[]{BidAskVolume$Values.ASK_VOL, BidAskVolume$Values.BID_VOL});
        runtimeDescriptor.setMinTick(Double.valueOf(1.0));
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.declareSignal((Object)BidAskVolume$Signals.CROSS_ABOVE, this.get("LBL_ASK_CROSS_ABOVE_BID", new Object[0]));
        runtimeDescriptor.declareSignal((Object)BidAskVolume$Signals.CROSS_BELOW, this.get("LBL_ASK_CROSS_BELOW_BID", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void clearState() {
        this.a = false;
        super.clearState();
    }

    protected void calculateValues(DataContext dataContext) {
        this.a = false;
        super.calculateValues(dataContext);
        this.a = true;
    }

    public void onBarUpdate(DataContext dataContext) {
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        if (!this.getSettings().getBoolean(b, false)) {
            int n3 = this.getSettings().getInteger(a);
            if (n2 < dataSeries.size() - n3 - 1) {
                return;
            }
        }
        Instrument instrument = dataContext.getInstrument();
        boolean bl2 = this.getSettings().getBoolean(c);
        long l2 = dataSeries.getStartTime(n2);
        long l3 = dataSeries.getEndTime(n2);
        long l4 = Util.getStartOfBar((long)l2, (long)l3, (Instrument)instrument, (BarSize)dataSeries.getBarSize(), (boolean)bl2);
        long l5 = Util.getEndOfBar((long)l2, (long)l3, (Instrument)instrument, (BarSize)dataSeries.getBarSize(), (boolean)bl2);
        b b2 = new b(null);
        instrument.forEachTick(l4, l5 - 1L, bl2, (TickOperation)b2);
        if (b2.c == 0.0f) {
            return;
        }
        dataSeries.setFloat(n2, (Object)BidAskVolume$Values.ASK_VOL, Float.valueOf(b2.b));
        dataSeries.setFloat(n2, (Object)BidAskVolume$Values.BID_VOL, Float.valueOf(b2.a));
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), (double)b2.b);
        if (this.crossedAbove(dataSeries, n2, (Object)BidAskVolume$Values.ASK_VOL, (Object)BidAskVolume$Values.BID_VOL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_ASK_VOL_CROSS_ABOVE", new Object[]{Float.valueOf(b2.b), Float.valueOf(b2.a)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            if (this.a) {
                dataContext.signal(n2, (Object)BidAskVolume$Signals.CROSS_ABOVE, string, (Object)Float.valueOf(b2.a));
            }
        } else if (this.crossedBelow(dataSeries, n2, (Object)BidAskVolume$Values.ASK_VOL, (Object)BidAskVolume$Values.BID_VOL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_ASK_VOL_CROSS_BELOW", new Object[]{Float.valueOf(b2.b), Float.valueOf(b2.a)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            if (this.a) {
                dataContext.signal(n2, (Object)BidAskVolume$Signals.CROSS_BELOW, string, (Object)Float.valueOf(b2.a));
            }
        }
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }

    public void onTick(DataContext dataContext, Tick tick) {
        float f2;
        Settings settings = this.getSettings();
        Instrument instrument = dataContext.getInstrument();
        boolean bl2 = settings.getBoolean(c, false);
        if (!this.a || !instrument.isInsideTradingHours(tick.getTime(), bl2)) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        float f3 = dataSeries.getFloat((Object)BidAskVolume$Values.ASK_VOL, 0.0f).floatValue();
        float f4 = dataSeries.getFloat((Object)BidAskVolume$Values.BID_VOL, 0.0f).floatValue();
        float f5 = f2 = tick.getVolumeAsFloat() <= 0.0f ? 1.0f : tick.getVolumeAsFloat();
        if (tick.isAskTick()) {
            f3 += f2;
        } else {
            f4 += f2;
        }
        dataSeries.setFloat((Object)BidAskVolume$Values.ASK_VOL, Float.valueOf(f3));
        dataSeries.setFloat((Object)BidAskVolume$Values.BID_VOL, Float.valueOf(f4));
    }
}

