/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.strategies;

import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.CmoAv;
import com.motivewave.platform.study.general.CmoAv$Signals;

@StudyHeader(namespace="com.motivewave", id="ID_CMOST", rb="com.motivewave.platform.study.nls.strings2", name="NAME_CMO_AV_STRATEGY", label="LBL_CMOST", desc="DESC_CMO", menu="MENU_TUSHAR_CHANDE", helpLink="http://www.motivewave.com/strategies/cmo_av_strategy.htm", overlay=false, signals=true, strategy=true, autoEntry=true, manualEntry=false, supportsUnrealizedPL=true, supportsRealizedPL=true, supportsTotalPL=true, supportsPositionType=true)
public class g
extends CmoAv {
    public void onActivate(OrderContext orderContext) {
        if (this.getSettings().isEnterOnActivate()) {
            DataSeries dataSeries = orderContext.getDataContext().getDataSeries();
            int n2 = dataSeries.isLastBarComplete() ? dataSeries.size() - 1 : dataSeries.size() - 2;
            Boolean bl2 = dataSeries.getBoolean(n2, (Object)CmoAv$Signals.BUY);
            Boolean bl3 = dataSeries.getBoolean(n2, (Object)CmoAv$Signals.SELL);
            if (bl2 == null || bl3 == null) {
                return;
            }
            int n3 = this.getSettings().getTradeLots();
            n3 = (int)((float)n3 * orderContext.getInstrument().getDefaultQuantityAsFloat());
            float f2 = n3;
            switch (this.getSettings().getPositionType()) {
                case LONG: {
                    if (!bl2.booleanValue()) break;
                    orderContext.buy(f2);
                    break;
                }
                case SHORT: {
                    if (!bl3.booleanValue()) break;
                    orderContext.sell(f2);
                    break;
                }
                default: {
                    if (bl2.booleanValue()) {
                        orderContext.buy(f2);
                        break;
                    }
                    orderContext.sell(f2);
                }
            }
        }
    }

    public void onSignal(OrderContext orderContext, Object object) {
        Instrument instrument = orderContext.getInstrument();
        float f2 = orderContext.getPositionAsFloat();
        float f3 = (float)this.getSettings().getTradeLots() * instrument.getDefaultQuantityAsFloat();
        switch (this.getSettings().getPositionType()) {
            case LONG: {
                if (f2 == 0.0f && object == CmoAv$Signals.BUY) {
                    orderContext.buy(f3);
                }
                if (!(f2 > 0.0f) || object != CmoAv$Signals.SELL) break;
                orderContext.sell(f3);
                break;
            }
            case SHORT: {
                if (f2 == 0.0f && object == CmoAv$Signals.SELL) {
                    orderContext.sell(f3);
                }
                if (!(f2 < 0.0f) || object != CmoAv$Signals.BUY) break;
                orderContext.buy(f3);
                break;
            }
            default: {
                if (f2 <= 0.0f && object == CmoAv$Signals.BUY) {
                    orderContext.buy(f3);
                }
                if (!(f2 >= 0.0f) || object != CmoAv$Signals.SELL) break;
                orderContext.sell(f3);
            }
        }
    }
}

