/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.strategies;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.general3.b;
import com.motivewave.platform.study.strategies.Account;
import com.motivewave.platform.study.strategies.Account$OrdType;
import com.motivewave.platform.study.strategies.Account$PosType;
import com.motivewave.platform.study.strategies.Account$Signal;
import com.motivewave.platform.study.strategies.ThreeBarInsideBarPatternStrategy$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", rb="com.motivewave.platform.study.nls.strings2", id="THREE_BAR_INSIDE_BAR", name="NAME_THREE_BAR_INSIDE_BAR_STRATEGY", desc="DESC_THREE_BAR_INSIDE_BAR", label="LBL_TBIBS", menu="MENU_GENERAL", helpLink="http://www.motivewave.com/strategies/three_bar_inside_bar_strategy.htm", overlay=true, signals=true, strategy=true, autoEntry=true, manualEntry=false, supportsEnterOnActivate=false, supportsUnrealizedPL=true, supportsRealizedPL=true, supportsTotalPL=true, supportsPositionType=false, supportsBarUpdates=false)
public class ThreeBarInsideBarPatternStrategy
extends Study {
    Marker a;
    long a;
    double a;
    Account a = new Account(Account$PosType.SAR, Account$OrdType.MARKET, 0.0f);

    public void initialize(Defaults defaults) {
        Account.a = this;
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("INPUTS", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(b.a, this.get("POSITION_TYPE", new Object[0]), (Object[])Account$PosType.values(), (Object)Account$PosType.SAR)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(b.b, this.get("ORDER_TYPE", new Object[0]), (Object[])Account$OrdType.values(), (Object)Account$OrdType.MARKET)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(b.c, this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b.ag, this.get("PROFIT_TARGET", new Object[0]), 0.75, 0.0, 10.01, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b.af, this.get("STOP_LOSS", new Object[0]), 0.75, 0.0, 10.01, 0.01)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup("Markers");
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.R, this.get("ENTER_LONG", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.S, this.get("EXIT_LONG", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.U, this.get("ENTER_SHORT", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getBlue(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.T, this.get("EXIT_SHORT", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getYellow(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.X, this.get("ACTIVE", new Object[0]), Enums.MarkerType.CIRCLE, Enums.Size.MEDIUM, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Account$Signal.ENTER_LONG, Enums.ValueType.CHOICE, this.get("ENTER_LONG", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Account$Signal.EXIT_LONG, Enums.ValueType.CHOICE, this.get("EXIT_LONG", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Account$Signal.ENTER_SHORT, Enums.ValueType.CHOICE, this.get("ENTER_SHORT", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Account$Signal.EXIT_SHORT, Enums.ValueType.CHOICE, this.get("EXIT_SHORT", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)Account$Signal.ENTER_LONG, this.get("ENTER_LONG", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Account$Signal.EXIT_LONG, this.get("EXIT_LONG", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Account$Signal.ENTER_SHORT, this.get("ENTER_SHORT", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Account$Signal.EXIT_SHORT, this.get("EXIT_SHORT", new Object[0]));
        runtimeDescriptor.setLabelSettings(new String[]{b.a, b.b, b.c, b.ae, b.ag, b.af});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onDeactivate(OrderContext orderContext) {
        this.a = 0L;
        if (this.getSettings().isCloseOnDeactivate()) {
            this.a.a(orderContext);
        }
        super.onDeactivate(orderContext);
        this.removeFigure((Figure)this.a);
        DataContext dataContext = orderContext.getDataContext();
        DataSeries dataSeries = dataContext.getDataSeries();
        int n2 = dataSeries.size() - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.calculate(i2, dataContext);
        }
    }

    public void onActivate(OrderContext orderContext) {
        DataSeries dataSeries = orderContext.getDataContext().getDataSeries();
        int n2 = n.a(dataSeries.isLastBarComplete(), dataSeries.size() - 1, dataSeries.size() - 2);
        this.a.a(orderContext);
        this.a = dataSeries.getStartTime(n2);
        double d2 = dataSeries.getLow(n2);
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
        this.a(coordinate);
        super.onActivate(orderContext);
    }

    public void onSignal(OrderContext orderContext, Object object) {
        Instrument instrument = orderContext.getInstrument();
        float f2 = (float)this.getSettings().getTradeLots() * instrument.getDefaultQuantityAsFloat();
        this.a.a(orderContext, (Account$Signal)((Object)object), f2, this.a);
    }

    public void onLoad(Defaults defaults) {
        this.setMinBars(21);
    }

    protected void calculate(int n2, DataContext dataContext) {
        boolean bl2;
        if (n2 < 2) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        if (dataSeries.getStartTime(n2) < this.a) {
            return;
        }
        this.a.a((Account$PosType)((Object)this.getSettings().getInput(b.a)));
        this.a.a = (Account$OrdType)((Object)this.getSettings().getInput(b.b));
        Object object = this.getSettings().getInput(b.c);
        double d2 = this.getSettings().getDouble(b.ag);
        double d3 = this.getSettings().getDouble(b.af);
        this.a = dataSeries.getDouble(n2, object, 0.0);
        double d4 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d5 = dataSeries.getHigh(n2);
        double d6 = dataSeries.getHigh(n2 - 1);
        double d7 = dataSeries.getLow(n2);
        double d8 = dataSeries.getLow(n2 - 1);
        this.a.d = (float)(this.a + this.a * d2 / 100.0);
        this.a.c = (float)(this.a - this.a * d2 / 100.0);
        float f2 = 0.0f;
        if (this.a.a != 0.0) {
            f2 = (float)(this.a.a - this.a.a * d3 / 100.0);
        }
        float f3 = Float.MAX_VALUE;
        if (this.a.b != 0.0) {
            f3 = (float)(this.a.b + this.a.b * d3 / 100.0);
        }
        boolean bl3 = this.a > d4;
        boolean bl4 = d5 < d6 && d7 > d8;
        boolean bl5 = this.a < d4;
        dataSeries.setBoolean(n2, (Object)ThreeBarInsideBarPatternStrategy$Values.COND1, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)ThreeBarInsideBarPatternStrategy$Values.COND2, Boolean.valueOf(bl4));
        dataSeries.setBoolean(n2, (Object)ThreeBarInsideBarPatternStrategy$Values.COND3, Boolean.valueOf(bl5));
        boolean bl6 = dataSeries.getBoolean(n2 - 2, (Object)ThreeBarInsideBarPatternStrategy$Values.COND1, false);
        boolean bl7 = dataSeries.getBoolean(n2 - 1, (Object)ThreeBarInsideBarPatternStrategy$Values.COND2, false);
        boolean bl8 = dataSeries.getBoolean(n2 - 2, (Object)ThreeBarInsideBarPatternStrategy$Values.COND3, false);
        boolean bl9 = bl3 && bl7 && bl6;
        boolean bl10 = bl5 && bl7 && bl8;
        boolean bl11 = this.a < (double)f2;
        boolean bl12 = bl2 = this.a > (double)f3;
        if (bl9) {
            Marker marker = new Marker(new Coordinate(dataSeries.getStartTime(n2), d7), Enums.Position.BOTTOM, this.getSettings().getMarker(b.R));
            marker.setTextValue(this.get("ENTER_LONG", new Object[0]));
            marker.setTextPosition(Enums.Position.BOTTOM);
            this.addFigure((Figure)marker);
            dataContext.signal(n2, (Object)Account$Signal.ENTER_LONG, this.get("ENTER_LONG_PRICE", new Object[0]) + Util.round((double)this.a, (int)3), (Object)this.a);
            dataSeries.setComplete(n2);
            return;
        }
        if (bl11) {
            Marker marker = new Marker(new Coordinate(dataSeries.getStartTime(n2), d5), Enums.Position.TOP, this.getSettings().getMarker(b.S));
            marker.setTextValue(this.get("EXIT_LONG", new Object[0]));
            marker.setTextPosition(Enums.Position.TOP);
            this.addFigure((Figure)marker);
            dataContext.signal(n2, (Object)Account$Signal.EXIT_LONG, this.get("EXIT_LONG_PRICE", new Object[0]) + Util.round((double)this.a, (int)3), (Object)this.a);
            dataSeries.setComplete(n2);
            return;
        }
        if (bl10) {
            Marker marker = new Marker(new Coordinate(dataSeries.getStartTime(n2), d5), Enums.Position.TOP, this.getSettings().getMarker(b.U));
            marker.setTextValue(this.get("ENTER_SHORT", new Object[0]));
            marker.setTextPosition(Enums.Position.TOP);
            this.addFigure((Figure)marker);
            dataContext.signal(n2, (Object)Account$Signal.ENTER_SHORT, this.get("ENTER_SHORT_PRICE", new Object[0]) + Util.round((double)this.a, (int)3), (Object)this.a);
            dataSeries.setComplete(n2);
            return;
        }
        if (bl2) {
            Marker marker = new Marker(new Coordinate(dataSeries.getStartTime(n2), d7), Enums.Position.BOTTOM, this.getSettings().getMarker(b.T));
            marker.setTextValue(this.get("EXIT_SHORT", new Object[0]));
            marker.setTextPosition(Enums.Position.BOTTOM);
            this.addFigure((Figure)marker);
            dataContext.signal(n2, (Object)Account$Signal.EXIT_SHORT, this.get("EXIT_SHORT_PRICE", new Object[0]) + Util.round((double)this.a, (int)3), (Object)this.a);
            dataSeries.setComplete(n2);
            return;
        }
        dataSeries.setComplete(n2);
    }

    public void a(Coordinate coordinate) {
        MarkerInfo markerInfo = this.getSettings().getMarker(b.X);
        this.a = new Marker(coordinate, Enums.Position.BOTTOM, markerInfo);
        this.a.setTextValue(this.get("ACTIVE", new Object[0]));
        this.a.setTextPosition(Enums.Position.BOTTOM);
        this.addFigure((Figure)this.a);
    }
}

