/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.strategies;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.Plot;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.general3.b;
import com.motivewave.platform.study.strategies.Account;
import com.motivewave.platform.study.strategies.Account$OrdType;
import com.motivewave.platform.study.strategies.Account$PosType;
import com.motivewave.platform.study.strategies.Account$Signal;
import com.motivewave.platform.study.strategies.RsiWithRsiStrategy$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", rb="com.motivewave.platform.study.nls.strings2", id="RSI_WITH_RSI", name="NAME_RSI_WITH_RSI_STRATEGY", desc="DESC_RSI_WITH_RSI", menu="MENU_GENERAL", helpLink="http://www.motivewave.com/strategies/rsi_with_rsi_strategy.htm", overlay=false, signals=true, strategy=true, autoEntry=true, manualEntry=false, supportsEnterOnActivate=false, supportsUnrealizedPL=true, supportsRealizedPL=true, supportsTotalPL=true, supportsPositionType=false)
public class RsiWithRsiStrategy
extends Study {
    static final String a = "RsiQuickPlot";
    Marker a;
    long a;
    Account a;
    Account b;
    boolean a;
    boolean b = false;
    double a = 0.0;

    public RsiWithRsiStrategy() {
        this.b = new Account(Account$PosType.SAR, Account$OrdType.MARKET, 0.0f);
    }

    public void initialize(Defaults defaults) {
        Account.a = this;
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("INPUTS", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(com.motivewave.platform.study.general3.b.b, this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor(com.motivewave.platform.study.general3.b.d, this.get("RSI_METHOD", new Object[0]), Enums.MAMethod.SMMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(com.motivewave.platform.study.general3.b.g, this.get("RSI_SLOW_PERIOD", new Object[0]), 17, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(com.motivewave.platform.study.general3.b.h, this.get("RSI_QUICK_PERIOD", new Object[0]), 5, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor(com.motivewave.platform.study.general3.b.e, this.get("MA_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(com.motivewave.platform.study.general3.b.i, this.get("MA_SLOW_PERIOD", new Object[0]), 40, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(com.motivewave.platform.study.general3.b.j, this.get("MA_QUICK_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        settingTab = new SettingTab(this.get("COLORS", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS_AND_INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(com.motivewave.platform.study.general3.b.m, this.get("RSI_SLOW_PATH", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(com.motivewave.platform.study.general3.b.n, this.get("RSI_QUICK_PATH", new Object[0]), defaults.getRed(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(com.motivewave.platform.study.general3.b.o, this.get("MA_SLOW_PATH", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(com.motivewave.platform.study.general3.b.p, this.get("MA_QUICK_PATH", new Object[0]), defaults.getRed(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(com.motivewave.platform.study.general3.b.v, this.get("RSI_SLOW_IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(com.motivewave.platform.study.general3.b.w, this.get("RSI_QUICK_IND", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(com.motivewave.platform.study.general3.b.x, this.get("MA_SLOW_IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(com.motivewave.platform.study.general3.b.y, this.get("MA_QUICK_IND", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("GUIDES", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("RSI_SLOW_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor(com.motivewave.platform.study.general3.b.B, this.get("TOP_GUIDE", new Object[0]), 61.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor(com.motivewave.platform.study.general3.b.C, this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor(com.motivewave.platform.study.general3.b.D, this.get("BOTTOM_GUIDE", new Object[0]), 39.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup3 = new SettingGroup(this.get("RSI_QUICK_GUIDES", new Object[0]));
        guideDescriptor = new GuideDescriptor(com.motivewave.platform.study.general3.b.E, this.get("TOP_GUIDE", new Object[0]), 61.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        guideDescriptor2 = new GuideDescriptor(com.motivewave.platform.study.general3.b.F, this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        guideDescriptor3 = new GuideDescriptor(com.motivewave.platform.study.general3.b.G, this.get("BOTTOM_GUIDE", new Object[0]), 39.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingTab = new SettingTab(this.get("SHADING", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup4 = new SettingGroup(this.get("RSI_SLOW_SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor(com.motivewave.platform.study.general3.b.N, this.get("TOP_FILL", new Object[0]), com.motivewave.platform.study.general3.b.C, com.motivewave.platform.study.general3.b.m, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor(com.motivewave.platform.study.general3.b.O, this.get("BOTTOM_FILL", new Object[0]), com.motivewave.platform.study.general3.b.C, com.motivewave.platform.study.general3.b.m, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        settingGroup4 = new SettingGroup(this.get("RSI_QUICK_SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor(com.motivewave.platform.study.general3.b.P, this.get("TOP_FILL", new Object[0]), com.motivewave.platform.study.general3.b.F, com.motivewave.platform.study.general3.b.n, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor(com.motivewave.platform.study.general3.b.Q, this.get("BOTTOM_FILL", new Object[0]), com.motivewave.platform.study.general3.b.F, com.motivewave.platform.study.general3.b.n, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        settingTab = new SettingTab(this.get("MARKERS", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup5 = new SettingGroup("Markers");
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(com.motivewave.platform.study.general3.b.Y, this.get("ENTER_LONG_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(com.motivewave.platform.study.general3.b.Z, this.get("EXIT_LONG_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(com.motivewave.platform.study.general3.b.X, this.get("ACTIVE", new Object[0]), Enums.MarkerType.CIRCLE, Enums.Size.MEDIUM, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RsiWithRsiStrategy$Values.RSI_SLOW, this.get("RSI_SLOW", new Object[0]), new String[]{com.motivewave.platform.study.general3.b.a, com.motivewave.platform.study.general3.b.g}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RsiWithRsiStrategy$Values.RSI_QUICK, this.get("RSI_QUICK", new Object[0]), new String[]{com.motivewave.platform.study.general3.b.a, com.motivewave.platform.study.general3.b.h}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RsiWithRsiStrategy$Values.MA_SLOW, this.get("MA_SLOW", new Object[0]), new String[]{com.motivewave.platform.study.general3.b.a, com.motivewave.platform.study.general3.b.e, com.motivewave.platform.study.general3.b.i}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RsiWithRsiStrategy$Values.MA_QUICK, this.get("MA_QUICK", new Object[0]), new String[]{com.motivewave.platform.study.general3.b.a, com.motivewave.platform.study.general3.b.e, com.motivewave.platform.study.general3.b.j}));
        runtimeDescriptor.declareSignal((Object)Account$Signal.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Account$Signal.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.getPricePlot().setLabelSettings(new String[]{com.motivewave.platform.study.general3.b.e, com.motivewave.platform.study.general3.b.i, com.motivewave.platform.study.general3.b.j});
        runtimeDescriptor.getPricePlot().setLabelPrefix(this.get("MA", new Object[0]));
        runtimeDescriptor.getPricePlot().declarePath((Object)RsiWithRsiStrategy$Values.MA_SLOW, com.motivewave.platform.study.general3.b.o);
        runtimeDescriptor.getPricePlot().declarePath((Object)RsiWithRsiStrategy$Values.MA_QUICK, com.motivewave.platform.study.general3.b.p);
        runtimeDescriptor.getPricePlot().declareIndicator((Object)RsiWithRsiStrategy$Values.MA_SLOW, com.motivewave.platform.study.general3.b.x);
        runtimeDescriptor.getPricePlot().declareIndicator((Object)RsiWithRsiStrategy$Values.MA_QUICK, com.motivewave.platform.study.general3.b.y);
        runtimeDescriptor.getPricePlot().setRangeKeys(new Object[]{RsiWithRsiStrategy$Values.MA_QUICK, RsiWithRsiStrategy$Values.MA_SLOW});
        runtimeDescriptor.setLabelSettings(new String[]{com.motivewave.platform.study.general3.b.d, com.motivewave.platform.study.general3.b.g});
        runtimeDescriptor.setLabelPrefix(this.get("RSI_SLOW", new Object[0]));
        runtimeDescriptor.setTabName(this.get("RSI_SLOW", new Object[0]));
        runtimeDescriptor.declarePath((Object)RsiWithRsiStrategy$Values.RSI_SLOW, com.motivewave.platform.study.general3.b.m);
        runtimeDescriptor.declareIndicator((Object)RsiWithRsiStrategy$Values.RSI_SLOW, com.motivewave.platform.study.general3.b.m);
        runtimeDescriptor.setRangeKeys(new Object[]{RsiWithRsiStrategy$Values.RSI_SLOW});
        Plot plot = new Plot();
        runtimeDescriptor.addPlot(a, plot);
        plot.setLabelSettings(new String[]{com.motivewave.platform.study.general3.b.d, com.motivewave.platform.study.general3.b.h});
        plot.setLabelPrefix(this.get("RSI_QUICK", new Object[0]));
        plot.setTabName(this.get("RSI_QUICK", new Object[0]));
        plot.declarePath((Object)RsiWithRsiStrategy$Values.RSI_QUICK, com.motivewave.platform.study.general3.b.n);
        plot.declareIndicator((Object)RsiWithRsiStrategy$Values.RSI_QUICK, com.motivewave.platform.study.general3.b.n);
        plot.setRangeKeys(new Object[]{RsiWithRsiStrategy$Values.RSI_QUICK});
        plot.declareGuide(com.motivewave.platform.study.general3.b.E);
        plot.declareGuide(com.motivewave.platform.study.general3.b.F);
        plot.declareGuide(com.motivewave.platform.study.general3.b.G);
        plot.setMaxBottomValue(Integer.valueOf(15));
        plot.setMinTopValue(Integer.valueOf(85));
        plot.setMinTick(Double.valueOf(0.1));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onDeactivate(OrderContext orderContext) {
        this.a = 0L;
        this.a.a(orderContext);
        this.b.a(orderContext);
        super.onDeactivate(orderContext);
        this.removeFigure((Figure)this.a);
        DataContext dataContext = orderContext.getDataContext();
        DataSeries dataSeries = dataContext.getDataSeries();
        int n2 = dataSeries.size() - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.calculate(i2, dataContext);
        }
    }

    public void onActivate(OrderContext orderContext) {
        DataSeries dataSeries = orderContext.getDataContext().getDataSeries();
        int n2 = n.a(dataSeries.isLastBarComplete(), dataSeries.size() - 1, dataSeries.size() - 2);
        this.a = dataSeries.getStartTime(n2);
        this.a.a(orderContext);
        this.b.a(orderContext);
        double d2 = dataSeries.getDouble(n2, (Object)RsiWithRsiStrategy$Values.RSI_SLOW, 0.0);
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
        this.a(coordinate);
        super.onActivate(orderContext);
    }

    public void onSignal(OrderContext orderContext, Object object) {
        Instrument instrument = orderContext.getInstrument();
        float f2 = (float)this.getSettings().getTradeLots() * instrument.getDefaultQuantityAsFloat();
        if (this.a) {
            this.a.a(orderContext, (Account$Signal)((Object)object), f2, this.a);
        }
        if (this.b) {
            this.b.a(orderContext, (Account$Signal)((Object)object), f2, this.a);
        }
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger(com.motivewave.platform.study.general3.b.g);
        int n3 = this.getSettings().getInteger(com.motivewave.platform.study.general3.b.h);
        int n4 = this.getSettings().getInteger(com.motivewave.platform.study.general3.b.i);
        int n5 = this.getSettings().getInteger(com.motivewave.platform.study.general3.b.j);
        this.setMinBars(n.a(n2, n3, n4, n5) + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4;
        int n5;
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        if (dataSeries.getStartTime(n2) < this.a) {
            return;
        }
        int n6 = this.getSettings().getInteger(com.motivewave.platform.study.general3.b.g);
        if (n2 <= n.a(n6, n5 = this.getSettings().getInteger(com.motivewave.platform.study.general3.b.h).intValue(), n4 = this.getSettings().getInteger(com.motivewave.platform.study.general3.b.i).intValue(), n3 = this.getSettings().getInteger(com.motivewave.platform.study.general3.b.j).intValue()) + 1) {
            return;
        }
        Object object = this.getSettings().getInput(com.motivewave.platform.study.general3.b.b);
        this.a = dataSeries.getDouble(n2, object, 0.0);
        double d2 = this.a - dataSeries.getDouble(n2 - 1, object);
        double d3 = 0.0;
        double d4 = 0.0;
        if (d2 > 0.0) {
            d3 = d2;
        } else {
            d4 = d2;
        }
        dataSeries.setDouble(n2, (Object)RsiWithRsiStrategy$Values.UP, Double.valueOf(d3));
        dataSeries.setDouble(n2, (Object)RsiWithRsiStrategy$Values.DOWN, Double.valueOf(Math.abs(d4)));
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod(com.motivewave.platform.study.general3.b.d);
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod(com.motivewave.platform.study.general3.b.e);
        Double d5 = dataSeries.ma(mAMethod, n2, n6, (Object)RsiWithRsiStrategy$Values.UP);
        Double d6 = dataSeries.ma(mAMethod, n2, n6, (Object)RsiWithRsiStrategy$Values.DOWN);
        if (d5 == null || d6 == null) {
            return;
        }
        double d7 = d5 / d6;
        double d8 = 100.0 - 100.0 / (1.0 + d7);
        dataSeries.setDouble(n2, (Object)RsiWithRsiStrategy$Values.RSI_SLOW, Double.valueOf(d8));
        Double d9 = dataSeries.ma(mAMethod, n2, n5, (Object)RsiWithRsiStrategy$Values.UP);
        Double d10 = dataSeries.ma(mAMethod, n2, n5, (Object)RsiWithRsiStrategy$Values.DOWN);
        if (d9 == null || d10 == null) {
            return;
        }
        double d11 = d9 / d10;
        double d12 = 100.0 - 100.0 / (1.0 + d11);
        dataSeries.setDouble(n2, (Object)RsiWithRsiStrategy$Values.RSI_QUICK, Double.valueOf(d12));
        double d13 = dataSeries.ma(mAMethod2, n2, n4, object);
        double d14 = dataSeries.ma(mAMethod2, n2, n3, object);
        dataSeries.setDouble(n2, (Object)RsiWithRsiStrategy$Values.MA_SLOW, Double.valueOf(d13));
        dataSeries.setDouble(n2, (Object)RsiWithRsiStrategy$Values.MA_QUICK, Double.valueOf(d14));
        double d15 = dataSeries.getDouble(n2 - 1, (Object)RsiWithRsiStrategy$Values.RSI_SLOW, d8);
        double d16 = dataSeries.getDouble(n2 - 1, (Object)RsiWithRsiStrategy$Values.RSI_QUICK, d12);
        GuideInfo guideInfo = this.getSettings().getGuide(com.motivewave.platform.study.general3.b.B);
        double d17 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide(com.motivewave.platform.study.general3.b.D);
        double d18 = guideInfo2.getValue();
        guideInfo = this.getSettings().getGuide(com.motivewave.platform.study.general3.b.E);
        double d19 = guideInfo.getValue();
        guideInfo2 = this.getSettings().getGuide(com.motivewave.platform.study.general3.b.G);
        double d20 = guideInfo2.getValue();
        boolean bl2 = d15 < d17 && d8 > d17 && this.a > d13;
        boolean bl3 = d16 < d19 && d12 > d19 && this.a > d14;
        boolean bl4 = d15 > d18 && d8 < d18 && this.a < d13;
        boolean bl5 = d16 > d20 && d12 < d20 && this.a < d14;
        this.a = bl2 || bl4;
        boolean bl6 = this.b = bl3 || bl5;
        if (bl2 || bl3) {
            Marker marker = new Marker(new Coordinate(dataSeries.getStartTime(n2), d8), Enums.Position.BOTTOM, this.getSettings().getMarker(com.motivewave.platform.study.general3.b.Y));
            marker.setTextValue(this.get("BUY", new Object[0]));
            marker.setTextPosition(Enums.Position.BOTTOM);
            this.addFigure((Figure)marker);
            dataContext.signal(n2, (Object)Account$Signal.BUY, this.get("BUY_PRICE", new Object[0]) + Util.round((double)this.a, (int)3), (Object)this.a);
            dataSeries.setComplete(n2);
            return;
        }
        if (bl4 || bl5) {
            Marker marker = new Marker(new Coordinate(dataSeries.getStartTime(n2), d8), Enums.Position.TOP, this.getSettings().getMarker(com.motivewave.platform.study.general3.b.Z));
            marker.setTextValue(this.get("SELL", new Object[0]));
            marker.setTextPosition(Enums.Position.TOP);
            this.addFigure((Figure)marker);
            dataContext.signal(n2, (Object)Account$Signal.SELL, this.get("SELL_PRICE", new Object[0]) + Util.round((double)this.a, (int)3), (Object)this.a);
            dataSeries.setComplete(n2);
            return;
        }
        dataSeries.setComplete(n2);
    }

    public void a(Coordinate coordinate) {
        MarkerInfo markerInfo = this.getSettings().getMarker(com.motivewave.platform.study.general3.b.X);
        this.a = new Marker(coordinate, Enums.Position.BOTTOM, markerInfo);
        this.a.setTextValue(this.get("ACTIVE", new Object[0]));
        this.a.setTextPosition(Enums.Position.BOTTOM);
        this.addFigure((Figure)this.a);
    }
}

