/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.strategies;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.Plot;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.general3.b;
import com.motivewave.platform.study.strategies.Account;
import com.motivewave.platform.study.strategies.Account$OrdType;
import com.motivewave.platform.study.strategies.Account$PosType;
import com.motivewave.platform.study.strategies.Account$Signal;
import com.motivewave.platform.study.strategies.PriceZoneStrategy$Values;
import java.awt.Color;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", rb="com.motivewave.platform.study.nls.strings2", id="ID_PRICE_ZONE_STRATEGY", name="NAME_PRICE_ZONE_STRATEGY", desc="DESC_PRICE_ZONE_STRATEGY", label="LBL_PZS", menu="MENU_GENERAL", helpLink="http://www.motivewave.com/strategies/price_zone_strategy.htm", overlay=false, signals=true, strategy=true, autoEntry=true, manualEntry=false, supportsEnterOnActivate=false, supportsUnrealizedPL=true, supportsRealizedPL=true, supportsTotalPL=true, supportsPositionType=false, supportsBarUpdates=false)
public class PriceZoneStrategy
extends Study {
    static final String a = "ReduceWS";
    Marker a;
    long a;
    double a;
    Account a = new Account(Account$PosType.SAR, Account$OrdType.MARKET, 0.0f);

    public void initialize(Defaults defaults) {
        Account.a = this;
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("DISPLAY1", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(b.a, this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor(b.d, this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b.g, this.get("PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b.h, this.get("MA_PERIOD", new Object[0]), 60, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(a, this.get("REDUCE_WHIPSAWS", new Object[0]), Boolean.valueOf(true))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b.m, this.get("PZO", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b.n, this.get("MA", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b.o, this.get("ADX_PATH", new Object[0]), defaults.getBlue(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(b.ac, this.get("ADX_UP_COLOR", new Object[0]), defaults.getBlue())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(b.ad, this.get("ADX_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("DISPLAY2", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b.v, this.get("PZO", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b.w, this.get("MA", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b.x, this.get("ADX", new Object[0]), defaults.getBlue(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("VZO_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor(b.B, this.get("TOP_GUIDE1", new Object[0]), 60.0, 0.0, 99.0, 1.0, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor(b.E, this.get("TOP_GUIDE2", new Object[0]), 40.0, 0.0, 99.0, 1.0, true);
        guideDescriptor2.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor(b.H, this.get("TOP_GUIDE3", new Object[0]), 15.0, 0.0, 99.0, 1.0, true);
        guideDescriptor3.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        GuideDescriptor guideDescriptor4 = new GuideDescriptor(b.C, this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -99.0, 99.0, 1.0, true);
        guideDescriptor4.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor4});
        GuideDescriptor guideDescriptor5 = new GuideDescriptor(b.D, this.get("BOTTOM_GUIDE1", new Object[0]), -5.0, 0.0, -99.0, 1.0, true);
        guideDescriptor5.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor5});
        GuideDescriptor guideDescriptor6 = new GuideDescriptor(b.G, this.get("BOTTOM_GUIDE2", new Object[0]), -40.0, 0.0, -99.0, 1.0, true);
        guideDescriptor6.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor6});
        GuideDescriptor guideDescriptor7 = new GuideDescriptor(b.J, this.get("BOTTOM_GUIDE3", new Object[0]), -60.0, 0.0, -99.0, 1.0, true);
        guideDescriptor7.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor7});
        settingTab.addGroup(settingGroup3);
        settingTab = new SettingTab(this.get("DISPLAY3", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup4 = new SettingGroup(this.get("ADX_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor8 = new GuideDescriptor(b.K, this.get("TOP_GUIDE", new Object[0]), 26.0, 0.0, 99.0, 1.0, true);
        guideDescriptor8.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor8});
        GuideDescriptor guideDescriptor9 = new GuideDescriptor(b.L, this.get("MIDDLE_GUIDE", new Object[0]), 18.0, 0.0, 99.0, 1.0, true);
        guideDescriptor9.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor9});
        GuideDescriptor guideDescriptor10 = new GuideDescriptor(b.M, this.get("BOTTOM_GUIDE", new Object[0]), 0.0, 0.0, 99.0, 1.0, true);
        guideDescriptor10.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor10});
        settingTab.addGroup(settingGroup4);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor(b.N, this.get("TOP_FILL", new Object[0]), b.C, b.m, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor(b.O, this.get("BOTTOM_FILL", new Object[0]), b.C, b.m, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup5 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.R, this.get("ENTER_LONG", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.S, this.get("EXIT_LONG", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.T, this.get("EXIT_SHORT", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getBlue(), defaults.getLineColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.U, this.get("ENTER_SHORT", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getYellow(), defaults.getLineColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor(b.X, this.get("ACTIVE", new Object[0]), Enums.MarkerType.CIRCLE, Enums.Size.MEDIUM, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        this.setRuntimeDescriptor(runtimeDescriptor);
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PriceZoneStrategy$Values.PZO, this.get("LBL_VZOSC", new Object[0]), new String[]{b.a, b.d, b.g}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Account$Signal.ENTER_LONG, Enums.ValueType.BOOLEAN, this.get("ENTER_LONG", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Account$Signal.EXIT_LONG, Enums.ValueType.BOOLEAN, this.get("EXIT_LONG", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Account$Signal.ENTER_SHORT, Enums.ValueType.BOOLEAN, this.get("ENTER_SHORT", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Account$Signal.EXIT_SHORT, Enums.ValueType.BOOLEAN, this.get("EXIT_SHORT", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)Account$Signal.ENTER_LONG, this.get("ENTER_LONG", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Account$Signal.EXIT_LONG, this.get("EXIT_LONG", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Account$Signal.ENTER_SHORT, this.get("ENTER_SHORT", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Account$Signal.EXIT_SHORT, this.get("EXIT_SHORT", new Object[0]));
        runtimeDescriptor.getPricePlot().setLabelSettings(new String[]{b.a, b.h});
        runtimeDescriptor.getPricePlot().setLabelPrefix("MA");
        runtimeDescriptor.getPricePlot().declarePath((Object)PriceZoneStrategy$Values.MA, b.n);
        runtimeDescriptor.getPricePlot().declareIndicator((Object)PriceZoneStrategy$Values.MA, b.w);
        runtimeDescriptor.setLabelSettings(new String[]{b.a, b.d, b.g});
        runtimeDescriptor.declarePath((Object)PriceZoneStrategy$Values.PZO, b.m);
        runtimeDescriptor.declareIndicator((Object)PriceZoneStrategy$Values.PZO, b.v);
        runtimeDescriptor.setRangeKeys(new Object[]{PriceZoneStrategy$Values.PZO});
        Plot plot = new Plot();
        runtimeDescriptor.addPlot(b.s, plot);
        plot.setLabelSettings(new String[]{b.a, b.g});
        plot.setLabelPrefix("ADX");
        plot.setTabName("ADX");
        plot.declarePath((Object)PriceZoneStrategy$Values.ADX, b.o);
        plot.declareBars((Object)PriceZoneStrategy$Values.ADX, b.o);
        plot.declareIndicator((Object)PriceZoneStrategy$Values.ADX, b.x);
        plot.declareGuide(b.K);
        plot.declareGuide(b.L);
        plot.declareGuide(b.M);
        plot.setRangeKeys(new Object[]{PriceZoneStrategy$Values.ADX});
    }

    public void onDeactivate(OrderContext orderContext) {
        this.a = 0L;
        this.a.a(orderContext);
        this.removeFigure((Figure)this.a);
        super.onDeactivate(orderContext);
        DataContext dataContext = orderContext.getDataContext();
        DataSeries dataSeries = dataContext.getDataSeries();
        int n2 = dataSeries.size() - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.calculate(i2, dataContext);
        }
    }

    public void onActivate(OrderContext orderContext) {
        DataSeries dataSeries = orderContext.getDataContext().getDataSeries();
        int n2 = n.a(dataSeries.isLastBarComplete(), dataSeries.size() - 1, dataSeries.size() - 2);
        this.a.a(orderContext);
        this.a = dataSeries.getStartTime(n2);
        double d2 = dataSeries.getDouble(n2, (Object)PriceZoneStrategy$Values.PZO, 0.0);
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
        this.a(coordinate);
        super.onActivate(orderContext);
    }

    public void onSignal(OrderContext orderContext, Object object) {
        Instrument instrument = orderContext.getInstrument();
        float f2 = (float)this.getSettings().getTradeLots() * instrument.getDefaultQuantityAsFloat();
        this.a.a(orderContext, (Account$Signal)((Object)object), f2, this.a);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger(b.g);
        int n3 = this.getSettings().getInteger(b.h);
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Marker marker;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3;
        int n4 = this.getSettings().getInteger(b.g);
        if (n2 < Math.max(n4, n3 = this.getSettings().getInteger(b.h).intValue())) {
            return;
        }
        Object object = this.getSettings().getInput(b.a, (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod(b.d);
        boolean bl2 = this.getSettings().getBoolean(a);
        Color color = this.getSettings().getColor(b.ac);
        Color color2 = this.getSettings().getColor(b.ad);
        DataSeries dataSeries = dataContext.getDataSeries();
        this.a = dataSeries.getDouble(n2, object, 0.0);
        double d2 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d3 = n.a(this.a > d2, this.a, -this.a);
        dataSeries.setDouble(n2, (Object)PriceZoneStrategy$Values.R, Double.valueOf(d3));
        Double d4 = dataSeries.ma(mAMethod, n2, n3, object);
        Double d5 = dataSeries.ma(mAMethod, n2, n4, (Object)PriceZoneStrategy$Values.R);
        Double d6 = dataSeries.ma(mAMethod, n2, n4, object);
        if (d4 == null || d5 == null || d6 == null) {
            return;
        }
        Double d7 = null;
        if (d6 != 0.0) {
            d7 = 100.0 * d5 / d6;
        }
        dataSeries.setDouble(n2, (Object)PriceZoneStrategy$Values.MA, d4);
        dataSeries.setDouble(n2, (Object)PriceZoneStrategy$Values.PZO, d7);
        if (d7 == null) {
            return;
        }
        double d8 = dataSeries.getDouble(n2 - 1, (Object)PriceZoneStrategy$Values.PZO, 0.0);
        Float f2 = dataSeries.getPositiveDM(n2);
        Float f3 = dataSeries.getNegativeDM(n2);
        Float f4 = dataSeries.getTrueRange(n2);
        dataSeries.setFloat(n2, (Object)PriceZoneStrategy$Values.PDM, f2);
        dataSeries.setFloat(n2, (Object)PriceZoneStrategy$Values.NDM, f3);
        dataSeries.setFloat(n2, (Object)PriceZoneStrategy$Values.TR, f4);
        if (n2 <= n4) {
            return;
        }
        Double d9 = dataSeries.smma(n2, n4, (Object)PriceZoneStrategy$Values.PDM);
        Double d10 = dataSeries.smma(n2, n4, (Object)PriceZoneStrategy$Values.NDM);
        Double d11 = dataSeries.smma(n2, n4, (Object)PriceZoneStrategy$Values.TR);
        if (d9 == null || d10 == null || d11 == null) {
            return;
        }
        double d12 = d9 / d11 * 100.0;
        double d13 = d10 / d11 * 100.0;
        double d14 = Math.abs(d9 - d10) / (d9 + d10) * 100.0;
        dataSeries.setDouble(n2, (Object)PriceZoneStrategy$Values.DX, Double.valueOf(d14));
        dataSeries.setDouble(n2, (Object)PriceZoneStrategy$Values.PDI, Double.valueOf(d12));
        dataSeries.setDouble(n2, (Object)PriceZoneStrategy$Values.NDI, Double.valueOf(d13));
        Double d15 = dataSeries.smma(n2, n4, (Object)PriceZoneStrategy$Values.DX);
        if (d15 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)PriceZoneStrategy$Values.ADX, d15);
        double d16 = this.getSettings().getGuide(b.B).getValue();
        double d17 = this.getSettings().getGuide(b.E).getValue();
        double d18 = this.getSettings().getGuide(b.H).getValue();
        double d19 = this.getSettings().getGuide(b.C).getValue();
        double d20 = this.getSettings().getGuide(b.J).getValue();
        double d21 = this.getSettings().getGuide(b.G).getValue();
        double d22 = this.getSettings().getGuide(b.D).getValue();
        double d23 = this.getSettings().getGuide(b.L).getValue();
        if (d15 > d23) {
            dataSeries.setBarColor(n2, (Object)PriceZoneStrategy$Values.ADX, color);
        } else {
            dataSeries.setBarColor(n2, (Object)PriceZoneStrategy$Values.ADX, color2);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (this.a > d4 && d15 > d23) {
            if (bl2) {
                boolean bl7 = bl3 = d8 < d21 && d7 > d21 || d8 < d18 && d7 > d18;
            }
            if (!bl2) {
                bl3 = d8 < d21 && d7 > d21 || d8 < d19 && d7 > d19;
            }
            boolean bl8 = bl4 = d8 > d16 && d7 < d8 || d8 > d17 && d7 < d17 || this.a < d4 && d7 < d19;
        }
        if (this.a < d4 && d15 > d23) {
            if (bl2) {
                boolean bl9 = bl5 = d8 > d17 && d7 < d17 || d8 > d22 && d7 < d22;
            }
            if (!bl2) {
                bl5 = d8 > d17 && d7 < d17 || d8 > d19 && d7 < d19;
            }
            boolean bl10 = bl6 = d7 < d20 && d7 > d8 || d8 < d21 && d7 > d21 || this.a > d4 && d8 < d19 && d7 > d19;
        }
        if (d15 < d23) {
            boolean bl11 = bl3 = d8 < d21 && d7 > d21 || d8 < d18 && d7 > d18;
            if (d8 < d17 && d7 > d17) {
                if (bl2) {
                    boolean bl12 = bl4 = d8 < d18 && d7 > d18;
                }
                if (!bl2) {
                    boolean bl13 = bl4 = d8 < d19 && d7 > d19;
                }
            }
            if (d7 < d17) {
                bl4 = d8 > d22 && d7 < d22;
            }
            bl5 = d8 > d17 && d7 < d17 || d8 > d22 && d7 < d22;
            boolean bl14 = bl6 = d8 > d21 && d7 < d21 || d7 > d18;
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker(b.R);
            marker = new Marker(coordinate, Enums.Position.BOTTOM, markerInfo);
            marker.setTextValue(this.get("ENTER_LONG", new Object[0]));
            marker.setTextPosition(Enums.Position.BOTTOM);
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)marker);
            }
            dataContext.signal(n2, (Object)Account$Signal.ENTER_LONG, this.get("ENTER_LONG_PRICE_PZO", new Object[]{Util.round((double)this.a, (int)3), Util.round((double)d7, (int)3)}), (Object)this.a);
        }
        if (bl4) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker(b.S);
            marker = new Marker(coordinate, Enums.Position.TOP, markerInfo);
            marker.setTextValue(this.get("EXIT_LONG", new Object[0]));
            marker.setTextPosition(Enums.Position.TOP);
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)marker);
            }
            dataContext.signal(n2, (Object)Account$Signal.EXIT_LONG, this.get("EXIT_LONG_PRICE_PZO", new Object[]{Util.round((double)this.a, (int)3), Util.round((double)d7, (int)3)}), (Object)this.a);
        }
        if (bl5) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker(b.U);
            marker = new Marker(coordinate, Enums.Position.TOP, markerInfo);
            marker.setTextValue(this.get("ENTER_SHORT", new Object[0]));
            marker.setTextPosition(Enums.Position.TOP);
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)marker);
            }
            dataContext.signal(n2, (Object)Account$Signal.ENTER_SHORT, this.get("ENTER_SHORT_PRICE_PZO", new Object[]{Util.round((double)this.a, (int)3), Util.round((double)d7, (int)3)}), (Object)this.a);
        }
        if (bl6) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker(b.T);
            marker = new Marker(coordinate, Enums.Position.BOTTOM, markerInfo);
            marker.setTextValue(this.get("EXIT_SHORT", new Object[0]));
            marker.setTextPosition(Enums.Position.BOTTOM);
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)marker);
            }
            dataContext.signal(n2, (Object)Account$Signal.EXIT_SHORT, this.get("EXIT_SHORT_PRICE_PZO", new Object[]{Util.round((double)this.a, (int)3), Util.round((double)d7, (int)3)}), (Object)this.a);
        }
        dataSeries.setComplete(n2);
    }

    public void a(Coordinate coordinate) {
        MarkerInfo markerInfo = this.getSettings().getMarker(b.X);
        this.a = new Marker(coordinate, Enums.Position.BOTTOM, markerInfo);
        this.a.setTextValue(this.get("ACTIVE", new Object[0]));
        this.a.setTextPosition(Enums.Position.BOTTOM);
        this.addFigure((Figure)this.a);
    }
}

