/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.FontInfo;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.FontDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Label;
import com.motivewave.platform.sdk.draw.Line;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;

@StudyHeader(namespace="com.motivewave", id="ZIG_ZAG", rb="com.motivewave.platform.study.nls.strings", name="TITLE_ZIG_ZAG", desc="DESC_ZIG_ZAG", menu="MENU_OVERLAY", overlay=true, studyOverlay=true, helpLink="http://www.motivewave.com/studies/zig_zag.htm")
public class s
extends Study {
    static final String a = "highInput";
    static final String b = "lowInput";
    static final String c = "reversal";
    static final String d = "priceMovements";
    static final String e = "priceLabels";
    static final String f = "retraceLine";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(a, this.get("LBL_HIGH_INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(b, this.get("LBL_LOW_INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(c, this.get("LBL_REVERSAL", new Object[0]), 1.0, 1.0E-4, 99.999, 1.0E-4)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(d, this.get("LBL_PRICE_MOVEMENTS", new Object[0]), Boolean.valueOf(true))});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(e, this.get("LBL_PRICE_LABELS", new Object[0]), Boolean.valueOf(true))});
        settingGroup.addRow(new SettingDescriptor[]{new FontDescriptor("font", this.get("LBL_FONT", new Object[0]), defaults.getFont())});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(f, this.get("LBL_RETRACE_LINE", new Object[0]), defaults.getLineColor(), 1.0f, new float[]{3.0f, 3.0f}, true, false, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{a, b, c});
        this.setRuntimeDescriptor(runtimeDescriptor);
        this.setMinBars(200);
    }

    protected void calculateValues(DataContext dataContext) {
        Line line;
        Object object = this.getSettings().getInput(a);
        Object object2 = this.getSettings().getInput(b);
        double d2 = this.getSettings().getDouble(c, 1.0) / 100.0;
        boolean bl2 = this.getSettings().getBoolean(d, true);
        boolean bl3 = this.getSettings().getBoolean(e, true);
        PathInfo pathInfo = this.getSettings().getPath("line");
        PathInfo pathInfo2 = this.getSettings().getPath(f);
        Defaults defaults = dataContext.getDefaults();
        FontInfo fontInfo = this.getSettings().getFont("font");
        Font font = fontInfo == null ? defaults.getFont() : fontInfo.getFont();
        Color color = defaults.getBackgroundColor();
        Color color2 = pathInfo.getColor();
        DataSeries dataSeries = dataContext.getDataSeries();
        Instrument instrument = dataContext.getInstrument();
        this.clearFigures();
        double d3 = dataSeries.getDouble(0, object);
        double d4 = dataSeries.getDouble(0, object2);
        int n2 = 0;
        int n3 = 0;
        boolean bl4 = false;
        double d5 = dataSeries.getDouble(1, object);
        bl4 = d5 > d3;
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        for (int i2 = 0; i2 < dataSeries.size() - 1; ++i2) {
            d5 = bl4 ? dataSeries.getDouble(i2, object).doubleValue() : dataSeries.getDouble(i2, object2).doubleValue();
            if (d5 > d3) {
                d3 = d5;
                n3 = i2;
                if (bl4) {
                    d4 = d3;
                    n2 = n3;
                }
            }
            if (d5 < d4) {
                d4 = d5;
                n2 = i2;
                if (!bl4) {
                    d3 = d4;
                    n3 = n2;
                }
            }
            if (bl4 && d4 < (1.0 - d2) * d3) {
                arrayList.add(new Coordinate(dataSeries.getStartTime(n3), (double)dataSeries.getHigh(n3)));
                d3 = d4;
                n3 = n2;
                bl4 = false;
            }
            if (bl4 || !(d3 > (1.0 + d2) * d4)) continue;
            arrayList.add(new Coordinate(dataSeries.getStartTime(n2), (double)dataSeries.getLow(n2)));
            d4 = d3;
            n2 = n3;
            bl4 = true;
        }
        if (bl4) {
            arrayList.add(new Coordinate(dataSeries.getStartTime(n3), (double)dataSeries.getHigh(n3)));
        } else {
            arrayList.add(new Coordinate(dataSeries.getStartTime(n2), (double)dataSeries.getLow(n2)));
        }
        Coordinate coordinate = null;
        Coordinate coordinate2 = null;
        for (Coordinate coordinate3 : arrayList) {
            if (coordinate != null) {
                line = new Line(coordinate, coordinate3, pathInfo);
                this.addFigure((Figure)line);
                if (bl2) {
                    line.setText(instrument.format(Math.abs(coordinate3.getValue() - coordinate.getValue())), font);
                    line.getText().setBackground(color);
                }
            }
            if (pathInfo2 != null && pathInfo2.isEnabled() && coordinate2 != null) {
                line = new Line(coordinate2, coordinate3, pathInfo2);
                double d6 = Math.abs(coordinate3.getValue() - coordinate.getValue());
                double d7 = Math.abs(coordinate2.getValue() - coordinate.getValue());
                double d8 = d6 / d7;
                line.setText(Util.round((double)(d8 * 100.0), (int)1) + "%", font);
                this.addFigure((Figure)line);
            }
            coordinate2 = coordinate;
            coordinate = coordinate3;
        }
        if (bl3) {
            for (Coordinate coordinate3 : arrayList) {
                line = new Label(instrument.format(coordinate3.getValue()), font, color2, color);
                line.setLocation(coordinate3);
                this.addFigure((Figure)line);
            }
        }
    }
}

