/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.FontInfo;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.SwingPoint;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.FontDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Label;
import com.motivewave.platform.sdk.draw.Line;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import java.awt.Color;
import java.awt.Font;

@StudyHeader(namespace="com.motivewave", id="PRICE_LABELS", rb="com.motivewave.platform.study.nls.strings", name="TITLE_PRICE_LABELS", desc="DESC_PRICE_LABELS", menu="MENU_OVERLAY", overlay=true, helpLink="http://www.motivewave.com/studies/price_labels.htm")
public class j
extends Study {
    static final String a = "topLabel";
    static final String b = "topBg";
    static final String c = "bottomLabel";
    static final String d = "bottomBg";
    static final String e = "extBars";
    static final String f = "extEnabled";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("topStrength", this.get("LBL_TOP_STRENGTH", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("bottomStrength", this.get("LBL_BOTTOM_STRENGTH", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(e, this.get("LBL_EXT_BARS", new Object[0]), 20, 1, 9999, 1), new BooleanDescriptor(f, this.get("LBL_ENABLED", new Object[0]), Boolean.valueOf(false))});
        settingGroup.addRow(new SettingDescriptor[]{new FontDescriptor("font", this.get("LBL_FONT", new Object[0]), defaults.getFont())});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(a, this.get("LBL_TOP_LABELS", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(b, this.get("LBL_TOP_BG", new Object[0]), defaults.getBackgroundColor())});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(c, this.get("LBL_BOTTOM_LABELS", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(d, this.get("LBL_BOTTOM_BG", new Object[0]), defaults.getBackgroundColor())});
        settingTab.addGroup(settingGroup2);
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(f, new String[]{e}));
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(a, new String[]{b}));
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(c, new String[]{d}));
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"topStrength", "bottomStrength"});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculateValues(DataContext dataContext) {
        Line line;
        Label label;
        Color color;
        Color color2;
        Boolean bl2;
        Defaults defaults = dataContext.getDefaults();
        int n2 = this.getSettings().getInteger("topStrength");
        int n3 = this.getSettings().getInteger("bottomStrength");
        Integer n4 = this.getSettings().getInteger(e);
        if (n4 == null) {
            n4 = 20;
        }
        if ((bl2 = this.getSettings().getBoolean(f)) == null) {
            bl2 = false;
        }
        PathInfo pathInfo = this.getSettings().getPath(a);
        PathInfo pathInfo2 = this.getSettings().getPath(c);
        FontInfo fontInfo = this.getSettings().getFont("font");
        Font font = defaults.getFont();
        if (fontInfo != null) {
            font = fontInfo.getFont();
        }
        if ((color2 = this.getSettings().getColor(b)) == null) {
            color2 = defaults.getBackgroundColor();
        }
        if ((color = this.getSettings().getColor(d)) == null) {
            color = defaults.getBackgroundColor();
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Instrument instrument = dataContext.getInstrument();
        this.clearFigures();
        if (pathInfo.isEnabled()) {
            for (SwingPoint swingPoint : dataSeries.calcSwingPoints(true, n2)) {
                label = new Label(instrument.format(swingPoint.getValue()), font, pathInfo.getColor(), color2);
                label.setLocation(swingPoint.getTime(), swingPoint.getValue());
                label.getText().setBorderStroke(pathInfo.getStroke());
                label.setLineStroke(defaults.getSolidLine());
                this.addFigure((Figure)label);
                if (!bl2.booleanValue()) continue;
                line = new Line(swingPoint.getTime(), swingPoint.getValue(), dataSeries.getStartTime(swingPoint.getIndex() + n4), swingPoint.getValue());
                line.setStroke(pathInfo.getStroke());
                line.setColor(pathInfo.getColor());
                this.addFigure((Figure)line);
            }
        }
        if (pathInfo2.isEnabled()) {
            for (SwingPoint swingPoint : dataSeries.calcSwingPoints(false, n3)) {
                label = new Label(instrument.format(swingPoint.getValue()), font, pathInfo2.getColor(), color);
                label.setLocation(swingPoint.getTime(), swingPoint.getValue());
                label.getText().setBorderStroke(pathInfo2.getStroke());
                label.setLineStroke(defaults.getSolidLine());
                this.addFigure((Figure)label);
                if (!bl2.booleanValue()) continue;
                line = new Line(swingPoint.getTime(), swingPoint.getValue(), dataSeries.getStartTime(swingPoint.getIndex() + n4), swingPoint.getValue());
                line.setStroke(pathInfo2.getStroke());
                line.setColor(pathInfo2.getColor());
                this.addFigure((Figure)line);
            }
        }
    }
}

