/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.FontInfo;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.FontDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Label;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.VolatilityStops$Signals;
import com.motivewave.platform.study.overlay.VolatilityStops$Values;
import java.awt.Font;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_VOLSTOP", rb="com.motivewave.platform.study.nls.strings2", label="LBL_VOLSTOP", name="NAME_VOLATILITY_STOPS", desc="DESC_VOLSTOP", helpLink="http://www.motivewave.com/studies/volatility_stops.htm", signals=true, overlay=true, studyOverlay=true)
public class VolatilityStops
extends Study {
    static final String[] a = new String[]{"Long", "Short"};
    static final String a = "Fac";
    static final String b = "Path1";
    static final String c = "Path2";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input2", this.get("POSITION", new Object[0]), (Object[])a, (Object)a[0])});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("MA_PERIOD", new Object[0]), 63, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("ATR_PERIOD", new Object[0]), 21, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("FACTOR", new Object[0]), 2.0, 1.0, 4.1, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new FontDescriptor("font", this.get("FONT", new Object[0]), defaults.getFont())});
        settingTab.addGroup(settingGroup);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor(b, this.get("LONG", new Object[0]), defaults.getBlue(), Enums.PointType.DOT, Enums.Size.SMALL, true, true, false);
        pathDescriptor.setSupportsMaxPoints(true);
        pathDescriptor.setSupportsColorPolicy(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        pathDescriptor = new PathDescriptor(c, this.get("SHORT", new Object[0]), defaults.getPurple(), Enums.PointType.DOT, Enums.Size.SMALL, true, true, false);
        pathDescriptor.setSupportsMaxPoints(true);
        pathDescriptor.setSupportsColorPolicy(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MA", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_VOLSTOP", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MA", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input2", "input", "method", "period", "period2", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolatilityStops$Values.MA, this.get("LBL_CHEXITS", new Object[0]), new String[]{"input2", "input", "method", "period", "period2", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolatilityStops$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolatilityStops$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)VolatilityStops$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)VolatilityStops$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)VolatilityStops$Values.VSTOP, "line");
        runtimeDescriptor.declarePath((Object)VolatilityStops$Values.MA, "line2");
        runtimeDescriptor.declareIndicator((Object)VolatilityStops$Values.VSTOP, "ind");
        runtimeDescriptor.declareIndicator((Object)VolatilityStops$Values.MA, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{VolatilityStops$Values.VSTOP, VolatilityStops$Values.MA});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3));
    }

    protected void calculate(int n2, DataContext dataContext) {
        Label label;
        Coordinate coordinate;
        boolean bl2;
        int n3;
        int n4 = this.getSettings().getInteger("period");
        if (n2 < Math.max(n4, n3 = this.getSettings().getInteger("period2").intValue())) {
            return;
        }
        String string = (String)this.getSettings().getInput("input2", (Object)a[0]);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        double d2 = this.getSettings().getDouble(a);
        FontInfo fontInfo = this.getSettings().getFont("font");
        Font font = fontInfo.getFont();
        PathInfo pathInfo = this.getSettings().getPath(b);
        PathInfo pathInfo2 = this.getSettings().getPath(c);
        boolean bl3 = string == "Long";
        boolean bl4 = bl2 = string == "Short";
        if (bl3) {
            this.getSettings().setPath("line", pathInfo);
        }
        if (bl2) {
            this.getSettings().setPath("line", pathInfo2);
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        boolean bl5 = false;
        boolean bl6 = false;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        Double d7 = dataSeries.ma(mAMethod, n2, n4, object);
        if (d7 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)VolatilityStops$Values.MA, d7);
        double d8 = dataSeries.getDouble(n2, object, 0.0);
        bl5 = d8 > d7;
        boolean bl7 = bl6 = d8 <= d7;
        if (bl3 && bl5) {
            d5 = dataSeries.atr(n2, n3);
            d4 = dataSeries.highest(n2, n3, object);
            d3 = d4 - d2 * d5;
        }
        if (bl2 && bl6) {
            d6 = dataSeries.atr(n2, n3);
            d4 = dataSeries.lowest(n2, n3, object);
            d3 = d4 + d2 * d6;
        }
        if (d3 != 0.0) {
            dataSeries.setDouble(n2 + 1, (Object)VolatilityStops$Values.VSTOP, Double.valueOf(d3));
        }
        dataSeries.setComplete(n2);
        Defaults defaults = dataContext.getDefaults();
        double d9 = dataSeries.getDouble(n2 - 1, object, 0.0);
        boolean bl8 = false;
        boolean bl9 = false;
        if (d3 != 0.0) {
            bl8 = d9 > d3 && d8 < d3 && bl3 && bl5;
            bl9 = d9 < d3 && d8 > d3 && bl2 && bl6;
        }
        dataSeries.setBoolean(n2, (Object)VolatilityStops$Signals.BUY, Boolean.valueOf(bl9));
        dataSeries.setBoolean(n2, (Object)VolatilityStops$Signals.SELL, Boolean.valueOf(bl8));
        if (bl8) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2 + 1), d8);
            label = new Label(this.get("EXIT_SELL", new Object[0]), font, defaults.getTextColor(), defaults.getRed());
            label.setLocation(coordinate);
            this.addFigure((Figure)label);
            dataContext.signal(n2, (Object)VolatilityStops$Signals.SELL, this.get("EXIT_SELL_PRICE_VSTOP", new Object[]{Util.round((double)d8, (int)2), Util.round((double)d3, (int)3)}), (Object)d8);
        }
        if (bl9) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2 + 1), d8);
            label = new Label(this.get("EXIT_BUY", new Object[0]), font, defaults.getTextColor(), defaults.getGreen());
            label.setLocation(coordinate);
            this.addFigure((Figure)label);
            dataContext.signal(n2, (Object)VolatilityStops$Signals.BUY, this.get("EXIT_BUY_PRICE_VSTOP", new Object[]{Util.round((double)d8, (int)2), Util.round((double)d3, (int)3)}), (Object)d8);
        }
    }
}

