/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.UniChannel$Signals;
import com.motivewave.platform.study.overlay.UniChannel$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_UNI_CH", rb="com.motivewave.platform.study.nls.strings2", desc="DESC_UNI_CH", name="NAME_UNI_CHANNEL", label="LBL_UC", menu="MENU_BANDS", helpLink="http://www.motivewave.com/studies/uni_channel.htm", requiresVolume=false, signals=true, overlay=true, studyOverlay=true)
public class UniChannel
extends Study {
    static final String a = "UbFac";
    static final String b = "LbFac";
    static final String c = "Ind3";
    static final String d = "Type1";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("UB_FACTOR", new Object[0]), 0.02, 0.0, 99.01, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("LB_FACTOR", new Object[0]), 0.02, 0.0, 99.01, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(d, this.get("TYPE1", new Object[0]), Boolean.valueOf(false))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("TOP", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MIDDLE", new Object[0]), defaults.getLineColor(), 1.0f, new float[]{3.0f, 3.0f}, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("BOTTOM", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("TOP", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MIDDLE", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(c, this.get("BOTTOM", new Object[0]), defaults.getGreen(), Color.WHITE, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup3);
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", a, b, d});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)UniChannel$Values.UB, this.get("UB", new Object[0]), new String[]{"input", "period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)UniChannel$Values.LB, this.get("LB", new Object[0]), new String[]{"input", "period", b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)UniChannel$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)UniChannel$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)UniChannel$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)UniChannel$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)UniChannel$Values.UB, "line");
        runtimeDescriptor.declarePath((Object)UniChannel$Values.MB, "line2");
        runtimeDescriptor.declarePath((Object)UniChannel$Values.LB, "line3");
        runtimeDescriptor.declareIndicator((Object)UniChannel$Values.UB, "ind");
        runtimeDescriptor.declareIndicator((Object)UniChannel$Values.MB, "ind2");
        runtimeDescriptor.declareIndicator((Object)UniChannel$Values.LB, c);
        runtimeDescriptor.setRangeKeys(new Object[]{UniChannel$Values.UB, UniChannel$Values.MB, UniChannel$Values.LB});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        double d2 = this.getSettings().getDouble(a);
        double d3 = this.getSettings().getDouble(b);
        boolean bl2 = this.getSettings().getBoolean(d);
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d4 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d4 == null) {
            return;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        if (bl2) {
            d5 = d4 + d2;
            d6 = d4 - d3;
        } else {
            d5 = d4 + d4 * d2;
            d6 = d4 - d4 * d3;
        }
        dataSeries.setDouble(n2, (Object)UniChannel$Values.UB, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)UniChannel$Values.MB, d4);
        dataSeries.setDouble(n2, (Object)UniChannel$Values.LB, Double.valueOf(d6));
        double d7 = dataSeries.getLow(n2);
        double d8 = dataSeries.getHigh(n2);
        boolean bl3 = d7 < d6;
        boolean bl4 = d8 > d5;
        dataSeries.setBoolean(n2, (Object)UniChannel$Signals.SELL, Boolean.valueOf(bl4));
        dataSeries.setBoolean(n2, (Object)UniChannel$Signals.BUY, Boolean.valueOf(bl3));
        if (bl4) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d8);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_UNIC_HIGH", new Object[]{Util.round((double)d8, (int)2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)UniChannel$Signals.SELL, string, (Object)d8);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_UNIC_LOW", new Object[]{Util.round((double)d7, (int)2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)UniChannel$Signals.BUY, string, (Object)d7);
        }
        dataSeries.setComplete(n2);
    }
}

