/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.TwoPoleButterFilter$Values;

@StudyHeader(namespace="com.motivewave", id="ID_TPBWF", rb="com.motivewave.platform.study.nls.strings2", label="LBL_TPBWF", name="NAME_TWO_POLE_BUTTERWORTH_FILTER", desc="DESC_TPBWF", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/two_pole_butterworth_filter.htm", signals=false, overlay=true, studyOverlay=true)
public class TwoPoleButterFilter
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_TPBWF", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TwoPoleButterFilter$Values.BUTTER, this.get("LBL_TPBWF", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)TwoPoleButterFilter$Values.BUTTER, "line");
        runtimeDescriptor.declareIndicator((Object)TwoPoleButterFilter$Values.BUTTER, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{TwoPoleButterFilter$Values.BUTTER});
        this.setRuntimeDescriptor(runtimeDescriptor);
        this.setMinBars(20);
    }

    protected void calculate(int n2, DataContext dataContext) {
        double d2;
        int n3 = this.getSettings().getInteger("period");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        if (n2 <= 2) {
            dataSeries.setDouble(n2, (Object)TwoPoleButterFilter$Values.BUTTER, Double.valueOf(d3));
            dataSeries.setComplete(n2);
            return;
        }
        double d4 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d5 = dataSeries.getDouble(n2 - 2, object, 0.0);
        double d6 = dataSeries.getDouble(n2 - 1, (Object)TwoPoleButterFilter$Values.BUTTER, d3);
        double d7 = dataSeries.getDouble(n2 - 2, (Object)TwoPoleButterFilter$Values.BUTTER, d3);
        double d8 = Math.PI / (double)n3;
        double d9 = Math.exp(-1.414 * d8);
        double d10 = d2 = 2.0 * d9 * Math.cos(1.414 * d8);
        double d11 = -d9 * d9;
        double d12 = (1.0 - d2 + d9 * d9) / 4.0;
        double d13 = d12 * (d3 + 2.0 * d4 + d5) + d10 * d6 + d11 * d7;
        dataSeries.setDouble(n2, (Object)TwoPoleButterFilter$Values.BUTTER, Double.valueOf(d13));
        dataSeries.setComplete(n2);
    }
}

