/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.TimeFrame;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.FontDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.TimeFrameDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.TimeFrameStudy$Signals;
import com.motivewave.platform.study.overlay.r;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="TIME_FRAME", rb="com.motivewave.platform.study.nls.strings", name="TITLE_TIME_FRAME", desc="DESC_TIME_FRAME", menu="MENU_OVERLAY", signals=true, overlay=true)
public class TimeFrameStudy
extends Study {
    static final String a = "timeframe";
    static final String b = "showRange";
    private List a = new ArrayList();

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new TimeFrameDescriptor(a, this.get("LBL_TIMEFRAME", new Object[0]), 39600000, 50400000, true, false)});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor("fill", this.get("LBL_FILL", new Object[0]), defaults.getGrey(), true, true)});
        settingGroup = new SettingGroup(this.get("LBL_RANGE", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(b, this.get("LBL_SHOW_RANGE", new Object[0]), Boolean.valueOf(false))});
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor("fill2", this.get("LBL_RANGE_FILL", new Object[0]), defaults.getYellow(), true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new FontDescriptor("font", this.get("LBL_FONT", new Object[0]), defaults.getFont(), defaults.getTextColor(), true, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new FontDescriptor("font2", this.get("LBL_RANGE_FONT", new Object[0]), defaults.getFont(), defaults.getTextColor(), true, true, true)});
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("marker", this.get("LBL_CROSS_ABOVE_HIGH", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("marker2", this.get("LBL_CROSS_BELOW_HIGH", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("marker4", this.get("LBL_CROSS_BELOW_LOW", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("marker3", this.get("LBL_CROSS_ABOVE_LOW", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(b, new String[]{"line", "line2", "fill2", "font", "font2", "marker", "marker2", "marker3", "marker4"}));
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{a});
        this.setRuntimeDescriptor(runtimeDescriptor);
        runtimeDescriptor.declareSignal((Object)TimeFrameStudy$Signals.CROSS_ABOVE_HIGH, this.get("LBL_CROSS_ABOVE_HIGH", new Object[0]));
        runtimeDescriptor.declareSignal((Object)TimeFrameStudy$Signals.CROSS_BELOW_HIGH, this.get("LBL_CROSS_BELOW_HIGH", new Object[0]));
        runtimeDescriptor.declareSignal((Object)TimeFrameStudy$Signals.CROSS_ABOVE_LOW, this.get("LBL_CROSS_ABOVE_LOW", new Object[0]));
        runtimeDescriptor.declareSignal((Object)TimeFrameStudy$Signals.CROSS_BELOW_LOW, this.get("LBL_CROSS_BELOW_LOW", new Object[0]));
    }

    public void onBarUpdate(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        this.a(dataContext, dataSeries.size() - 1);
    }

    protected void calculateValues(DataContext dataContext) {
        int n2;
        long l2;
        this.clearFigures();
        Settings settings = this.getSettings();
        DataSeries dataSeries = dataContext.getDataSeries();
        long l3 = 86400000L;
        long l4 = dataSeries.getStartTime(0);
        long l5 = dataContext.getCurrentTime() + 15L * l3;
        TimeFrame timeFrame = settings.getTimeFrame(a);
        boolean bl2 = settings.getBoolean(b, false);
        Instrument instrument = dataContext.getInstrument();
        ArrayList<r> arrayList = new ArrayList<r>();
        if (!dataSeries.getBarSize().isIntraday()) {
            this.a = arrayList;
            return;
        }
        long l6 = l2 = Util.getMidnight((long)l4, (TimeZone)dataContext.getTimeZone());
        long l7 = dataContext.getCurrentTime();
        r r2 = null;
        while (l2 < l5) {
            int n3;
            n2 = timeFrame.getStartTime();
            if (n2 > (n3 = timeFrame.getEndTime())) {
                l6 = Util.getMidnight((long)(l2 + l3), (TimeZone)dataContext.getTimeZone());
                if (l6 <= l2) {
                    l6 = l2 + l3;
                }
            } else {
                l6 = l2;
            }
            r r3 = new r(this, l2 + (long)n2, l6 + (long)n3);
            this.addFigure(r3);
            arrayList.add(r3);
            long l8 = Util.getMidnight((long)(l2 + l3), (TimeZone)dataContext.getTimeZone());
            if (l8 <= l2) {
                l8 = l2 + l3;
            }
            if (bl2 && l7 > l2 + (long)n2) {
                int n4 = dataSeries.findIndex(l2 + (long)n2);
                int n5 = dataSeries.findIndex(l6 + (long)n3 - 100L);
                if (dataSeries.getStartTime(n4) > l6 + (long)n3 || dataSeries.getStartTime(n5) < l2 + (long)n2) {
                    l2 = l8;
                    continue;
                }
                Double d2 = dataSeries.highest(n5, n5 - n4 + 1, (Object)Enums.BarInput.HIGH);
                Double d3 = dataSeries.lowest(n5, n5 - n4 + 1, (Object)Enums.BarInput.LOW);
                if (d2 != null && d3 != null) {
                    double d4 = instrument.round(d2.doubleValue());
                    double d5 = instrument.round(d3.doubleValue());
                    r3.a = d4;
                    r3.b = d5;
                    r3.a = true;
                    if (l8 + (long)n2 > l7) {
                        r3.b = true;
                    }
                    r3.c = l8 + (long)n2;
                }
            }
            if (r2 != null) {
                r2.c = r3.a;
            }
            l2 = l8;
            r2 = r3;
        }
        this.a = arrayList;
        for (n2 = 0; n2 <= dataSeries.size(); ++n2) {
            dataSeries.setBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_ABOVE_HIGH, Boolean.valueOf(false));
            dataSeries.setBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_BELOW_HIGH, Boolean.valueOf(false));
            dataSeries.setBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_ABOVE_LOW, Boolean.valueOf(false));
            dataSeries.setBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_BELOW_LOW, Boolean.valueOf(false));
        }
        for (n2 = 0; n2 < dataSeries.size(); ++n2) {
            this.a(dataContext, n2);
        }
    }

    protected r a(long l2) {
        for (r r2 : this.a) {
            if (r2.a > l2 || r2.c <= l2) continue;
            return r2;
        }
        return null;
    }

    void a(DataContext dataContext, int n2) {
        String string;
        MarkerInfo markerInfo;
        DataSeries dataSeries = dataContext.getDataSeries();
        long l2 = dataSeries.getStartTime(n2);
        r r2 = this.a(dataSeries.getStartTime(n2));
        if (r2 == null) {
            return;
        }
        if (r2.a <= l2 && r2.b > l2) {
            return;
        }
        double d2 = r2.a;
        double d3 = r2.b;
        float f2 = dataSeries.getClose(n2);
        if (!dataSeries.getBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_ABOVE_HIGH, false) && this.b(dataSeries, n2, d2)) {
            dataSeries.setBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_ABOVE_HIGH, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker("marker");
            string = this.get("SIGNAL_CROSS_ABOVE_HIGH", new Object[]{this.format(f2), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), d2), Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TimeFrameStudy$Signals.CROSS_ABOVE_HIGH, string, (Object)this.round(d2));
        } else if (!dataSeries.getBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_BELOW_HIGH, false) && this.a(dataSeries, n2, d2)) {
            dataSeries.setBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_BELOW_HIGH, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker("marker2");
            string = this.get("SIGNAL_CROSS_BELOW_HIGH", new Object[]{this.format(f2), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), d2), Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TimeFrameStudy$Signals.CROSS_BELOW_HIGH, string, (Object)this.round(d2));
        }
        if (!dataSeries.getBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_ABOVE_LOW, false) && this.b(dataSeries, n2, d3)) {
            dataSeries.setBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_ABOVE_LOW, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker("marker3");
            string = this.get("SIGNAL_CROSS_ABOVE_LOW", new Object[]{this.format(f2), this.format(d3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), d3), Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TimeFrameStudy$Signals.CROSS_ABOVE_LOW, string, (Object)this.round(d3));
        } else if (!dataSeries.getBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_BELOW_LOW, false) && this.a(dataSeries, n2, d3)) {
            dataSeries.setBoolean(n2, (Object)TimeFrameStudy$Signals.CROSS_BELOW_LOW, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker("marker4");
            string = this.get("SIGNAL_CROSS_BELOW_LOW", new Object[]{this.format(f2), this.format(d3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), d3), Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TimeFrameStudy$Signals.CROSS_BELOW_LOW, string, (Object)this.round(d3));
        }
    }

    boolean a(DataSeries dataSeries, int n2, double d2) {
        double d3 = this.round(dataSeries.getClose(n2 - 1));
        double d4 = this.round(dataSeries.getLow(n2));
        return d3 >= d2 && d4 < d2;
    }

    boolean b(DataSeries dataSeries, int n2, double d2) {
        double d3 = this.round(dataSeries.getClose(n2 - 1));
        double d4 = this.round(dataSeries.getHigh(n2));
        return d3 <= d2 && d4 > d2;
    }
}

