/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.TFSTetherLine$Signals;
import com.motivewave.platform.study.overlay.TFSTetherLine$Values;

@StudyHeader(namespace="com.motivewave", id="ID_TFSTL", rb="com.motivewave.platform.study.nls.strings2", desc="DESC_TFSTL", name="NAME_TFS_TETHER_LINE", label="LBL_TFSTL", helpLink="http://www.motivewave.com/studies/tfs_tether_line.htm", requiresVolume=false, signals=true, overlay=true, studyOverlay=true)
public class TFSTetherLine
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 50, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_TFSTL", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TFSTetherLine$Values.TL, this.get("LBL_TFSTL", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TFSTetherLine$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TFSTetherLine$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)TFSTetherLine$Values.TL, "line");
        runtimeDescriptor.declareIndicator((Object)TFSTetherLine$Values.TL, "ind");
        runtimeDescriptor.declareSignal((Object)TFSTetherLine$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)TFSTetherLine$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{TFSTetherLine$Values.TL});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        double d3 = dataSeries.lowest(n2, n3, (Object)Enums.BarInput.LOW);
        double d4 = (d2 + d3) / 2.0;
        dataSeries.setDouble(n2, (Object)TFSTetherLine$Values.TL, Double.valueOf(d4));
        double d5 = dataSeries.getHigh(n2);
        double d6 = dataSeries.getLow(n2);
        double d7 = dataSeries.getHigh(n2 - 1);
        double d8 = dataSeries.getLow(n2 - 1);
        double d9 = dataSeries.getDouble(n2 - 1, (Object)TFSTetherLine$Values.TL, 0.0);
        boolean bl2 = d9 > d7 && d4 < d5;
        boolean bl3 = d9 < d8 && d4 > d6;
        dataSeries.setBoolean(n2, (Object)TFSTetherLine$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)TFSTetherLine$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_HIGH_TFSTL", new Object[]{Util.round((double)d5, (int)2), Util.round((double)d4, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TFSTetherLine$Signals.SELL, string, (Object)d5);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_LOW_TFSTL", new Object[]{Util.round((double)d6, (int)2), Util.round((double)d4, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TFSTetherLine$Signals.BUY, string, (Object)d6);
        }
        dataSeries.setComplete(n2);
    }
}

