/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.SupportResistance$Signals;
import com.motivewave.platform.study.overlay.SupportResistance$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="SUPPORT_RESISTANCE", rb="com.motivewave.platform.study.nls.strings", name="TITLE_SUPPORT_RESISTANCE", desc="DESC_SUPPORT_RESISTANCE", menu="MENU_OVERLAY", overlay=true, signals=true, helpLink="http://www.motivewave.com/studies/support_resistance.htm")
public class SupportResistance
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("topLine", this.get("LBL_RESISTANCE_LINE", new Object[0]), defaults.getRed(), Enums.PointType.DOT, Enums.Size.VERY_SMALL, true, false, true);
        pathDescriptor.setSupportsBoth(true);
        settingGroup3.addRow(new SettingDescriptor[]{pathDescriptor});
        PathDescriptor pathDescriptor2 = new PathDescriptor("bottomLine", this.get("LBL_SUPPORT_LINE", new Object[0]), defaults.getBlue(), Enums.PointType.DOT, Enums.Size.VERY_SMALL, true, false, true);
        pathDescriptor2.setSupportsBoth(true);
        settingGroup3.addRow(new SettingDescriptor[]{pathDescriptor2});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("topInd", this.get("LBL_RESISTANCE_IND", new Object[0]), defaults.getRed(), Color.WHITE, false, false, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("bottomInd", this.get("LBL_SUPPORT_IND", new Object[0]), defaults.getBlue(), Color.WHITE, false, false, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SupportResistance$Values.RESISTANCE, this.get("LBL_RESISTANCE", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SupportResistance$Values.SUPPORT, this.get("LBL_SUPPORT", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SupportResistance$Signals.CROSS_RESISTANCE, Enums.ValueType.BOOLEAN, this.get("LBL_CROSS_RESISTANCE", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SupportResistance$Signals.CROSS_SUPPORT, Enums.ValueType.BOOLEAN, this.get("LBL_CROSS_SUPPORT", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)SupportResistance$Values.RESISTANCE, "topLine");
        runtimeDescriptor.declarePath((Object)SupportResistance$Values.SUPPORT, "bottomLine");
        runtimeDescriptor.declareIndicator((Object)SupportResistance$Values.RESISTANCE, "topInd");
        runtimeDescriptor.declareIndicator((Object)SupportResistance$Values.SUPPORT, "bottomInd");
        runtimeDescriptor.setRangeKeys(new Object[]{SupportResistance$Values.RESISTANCE, SupportResistance$Values.SUPPORT});
        runtimeDescriptor.declareSignal((Object)SupportResistance$Signals.CROSS_RESISTANCE, this.get("LBL_CROSS_RESISTANCE", new Object[0]));
        runtimeDescriptor.declareSignal((Object)SupportResistance$Signals.CROSS_SUPPORT, this.get("LBL_CROSS_SUPPORT", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 <= n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = this.getSettings().getInput("input");
        Double d2 = dataSeries.getDouble(n2 - 1, object);
        Double d3 = dataSeries.getDouble(n2, object);
        if (d2 == null || d3 == null) {
            return;
        }
        double d4 = dataSeries.sma(n2 - 1, n3, object);
        boolean bl2 = d2 < d4 && d3 >= d4;
        boolean bl3 = d2 > d4 && d3 <= d4;
        Double d5 = dataSeries.getDouble(n2 - 1, (Object)SupportResistance$Values.RESISTANCE);
        Double d6 = dataSeries.getDouble(n2 - 1, (Object)SupportResistance$Values.SUPPORT);
        if (bl3) {
            d5 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        }
        if (bl2) {
            d6 = dataSeries.lowest(n2, n3, (Object)Enums.BarInput.LOW);
        }
        if (d6 != null && d2 >= d6 && d3 < d6) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6.doubleValue());
            dataSeries.setBoolean(n2, (Object)SupportResistance$Signals.CROSS_SUPPORT, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SIGNAL_CROSS_SUPPORT", new Object[]{this.format(d3), this.format(d6)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SupportResistance$Signals.CROSS_SUPPORT, string, (Object)d3);
        }
        if (d5 != null && d2 <= d5 && d3 > d5) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5.doubleValue());
            dataSeries.setBoolean(n2, (Object)SupportResistance$Signals.CROSS_RESISTANCE, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("SIGNAL_CROSS_RESISTANCE", new Object[]{this.format(d3), this.format(d5)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SupportResistance$Signals.CROSS_RESISTANCE, string, (Object)d3);
        }
        boolean bl4 = dataSeries.isBarComplete(n2);
        if (d5 == null) {
            d5 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
            bl4 = false;
        }
        if (d6 == null) {
            d6 = dataSeries.lowest(n2, n3, (Object)Enums.BarInput.LOW);
            bl4 = false;
        }
        dataSeries.setDouble(n2, (Object)SupportResistance$Values.SUPPORT, d6);
        dataSeries.setDouble(n2, (Object)SupportResistance$Values.RESISTANCE, d5);
        dataSeries.setComplete(n2, bl4);
    }
}

