/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.SuperTrend$Signals;
import com.motivewave.platform.study.overlay.SuperTrend$Values;

@StudyHeader(namespace="com.motivewave", id="ID_SUPERTREND", rb="com.motivewave.platform.study.nls.strings", label="LBL_SUPERTREND", menu="MENU_GENERAL", name="LBL_SUPERTREND", desc="DESC_SUPERTREND", signals=true, overlay=true, studyOverlay=true)
public class SuperTrend
extends Study {
    static final String a = "multiplier";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("LBL_MULTIPLIER", new Object[0]), 3.0, 0.01, 999.0, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_ATR_PERIOD", new Object[0]), 7, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true);
        pathDescriptor.setSupportsColor(false);
        pathDescriptor.setSupportsShadeType(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreenLine(), true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRedLine(), true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.ARROW, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.ARROW, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{a, "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SuperTrend$Values.TSL, this.get("LBL_SUPERTREND", new Object[0]), new String[]{a, "period"}));
        runtimeDescriptor.declarePath((Object)SuperTrend$Values.TSL, "line");
        runtimeDescriptor.declareIndicator((Object)SuperTrend$Values.TSL, "ind");
        runtimeDescriptor.declareSignal((Object)SuperTrend$Signals.BUY, this.get("LBL_BUY_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)SuperTrend$Signals.SELL, this.get("LBL_SELL_SIGNAL", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{SuperTrend$Values.TSL});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public int getMinBars() {
        return this.getSettings().getInteger("period");
    }

    protected void calculate(int n2, DataContext dataContext) {
        double d2 = this.getSettings().getDouble(a);
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d3 = dataSeries.atr(n2, n3);
        if (d3 == null) {
            return;
        }
        float f2 = (dataSeries.getHigh(n2) + dataSeries.getLow(n2)) / 2.0f;
        double d4 = (double)f2 - d2 * d3;
        double d5 = (double)f2 + d2 * d3;
        Double d6 = dataSeries.getDouble(n2 - 1, (Object)SuperTrend$Values.UP);
        Double d7 = dataSeries.getDouble(n2 - 1, (Object)SuperTrend$Values.DOWN);
        Double d8 = dataSeries.getDouble(n2 - 1, (Object)SuperTrend$Values.TREND);
        float f3 = dataSeries.getClose(n2);
        float f4 = dataSeries.getClose(n2 - 1);
        if (d6 != null && (double)f4 > d6) {
            d4 = Util.max((double)d4, (double)d6);
        }
        if (d7 != null && (double)f4 < d7) {
            d5 = Util.min((double[])new double[]{d5, d7});
        }
        double d9 = 1.0;
        if (d7 != null && (double)f3 > d7) {
            d9 = 1.0;
        } else if (d6 != null && (double)f3 < d6) {
            d9 = -1.0;
        } else if (d8 != null) {
            d9 = d8;
        }
        dataSeries.setDouble(n2, (Object)SuperTrend$Values.TREND, Double.valueOf(d9));
        dataSeries.setDouble(n2, (Object)SuperTrend$Values.UP, Double.valueOf(d4));
        dataSeries.setDouble(n2, (Object)SuperTrend$Values.DOWN, Double.valueOf(d5));
        boolean bl2 = d8 != null && d9 != d8;
        boolean bl3 = dataSeries.isBarComplete(n2);
        if (d9 > 0.0) {
            dataSeries.setDouble(n2, (Object)SuperTrend$Values.TSL, Double.valueOf(d4));
            dataSeries.setPathColor(n2, (Object)SuperTrend$Values.TSL, this.getSettings().getColor("upColor", dataContext.getDefaults().getGreenLine()));
            if (bl2) {
                dataSeries.setPathColor(n2 - 1, (Object)SuperTrend$Values.TSL, this.getSettings().getColor("upColor", dataContext.getDefaults().getGreenLine()));
                if (bl3) {
                    MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
                    String string = this.get("SIGNAL_SUPERTREND_BUY", new Object[]{Float.valueOf(f3)});
                    if (markerInfo.isEnabled()) {
                        this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), (double)dataSeries.getLow(n2)), Enums.Position.BOTTOM, markerInfo, string));
                    }
                    dataContext.signal(n2, (Object)SuperTrend$Signals.BUY, string, (Object)Float.valueOf(f3));
                }
            }
        } else {
            dataSeries.setDouble(n2, (Object)SuperTrend$Values.TSL, Double.valueOf(d5));
            dataSeries.setPathColor(n2, (Object)SuperTrend$Values.TSL, this.getSettings().getColor("downColor", dataContext.getDefaults().getRedLine()));
            if (bl2) {
                dataSeries.setPathColor(n2 - 1, (Object)SuperTrend$Values.TSL, this.getSettings().getColor("downColor", dataContext.getDefaults().getRedLine()));
                if (bl3) {
                    MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
                    String string = this.get("SIGNAL_SUPERTREND_SELL", new Object[]{Float.valueOf(f3)});
                    if (markerInfo.isEnabled()) {
                        this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), (double)dataSeries.getHigh(n2)), Enums.Position.TOP, markerInfo, string));
                    }
                    dataContext.signal(n2, (Object)SuperTrend$Signals.SELL, string, (Object)Float.valueOf(f3));
                }
            }
        }
        dataSeries.setComplete(n2, bl3);
    }
}

