/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.overlay.StarcBands$Signals;
import com.motivewave.platform.study.overlay.StarcBands$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_STARC_BANDS", rb="com.motivewave.platform.study.nls.strings2", name="NAME_STARC_BANDS", menu="MENU_BANDS", desc="DESC_STARC", label="LBL_STARC", helpLink="http://www.motivewave.com/studies/starc_bands.htm", overlay=true, signals=true, studyOverlay=true)
public class StarcBands
extends Study {
    static final String a = "atrMult";
    static final String b = "bbMult";
    static final String c = "Path5";
    static final String d = "Ind3";
    static final String e = "Ind4";
    static final String f = "Ind5";
    private boolean a = true;
    private boolean b = true;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("MA_PERIOD", new Object[0]), 6, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("STARC_PERIOD", new Object[0]), 15, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("BB_PERIOD", new Object[0]), 6, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("ATR_MULTIPLER", new Object[0]), 2.0, 0.1, 999.0, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("BB_MULTIPLER", new Object[0]), 2.0, 0.1, 999.0, 0.1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("STARC_TOP", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MA", new Object[0]), defaults.getBlue(), 1.0f, new float[]{3.0f, 3.0f}, true, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("STARC_BOTT", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new PathDescriptor("line4", this.get("BB_TOP", new Object[0]), defaults.getLineColor(), 1.0f, new float[]{5.0f, 5.0f}, true, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new PathDescriptor(c, this.get("BB_BOTT", new Object[0]), defaults.getLineColor(), 1.0f, new float[]{5.0f, 5.0f}, true, true, true)});
        settingTab.addGroup(settingGroup3);
        settingGroup3 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("STARC_TOP", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MA", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(d, this.get("STARC_BOTT", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(e, this.get("BB_TOP", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("BB_BOTT", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", "period3", a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StarcBands$Values.ST_TOP, this.get("STARC_TOP", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StarcBands$Values.MA, this.get("MA", new Object[0]), new String[]{"input", "method", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StarcBands$Values.ST_BOTT, this.get("STARC_BOTT", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StarcBands$Values.BB_TOP, this.get("BB_TOP", new Object[0]), new String[]{"input", "period3", b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StarcBands$Values.BB_BOTT, this.get("BB_BOTT", new Object[0]), new String[]{"input", "period3", b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StarcBands$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StarcBands$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)StarcBands$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)StarcBands$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)StarcBands$Values.ST_TOP, "line");
        runtimeDescriptor.declarePath((Object)StarcBands$Values.MA, "line2");
        runtimeDescriptor.declarePath((Object)StarcBands$Values.ST_BOTT, "line3");
        runtimeDescriptor.declarePath((Object)StarcBands$Values.BB_TOP, "line4");
        runtimeDescriptor.declarePath((Object)StarcBands$Values.BB_BOTT, c);
        runtimeDescriptor.declareIndicator((Object)StarcBands$Values.ST_TOP, "ind");
        runtimeDescriptor.declareIndicator((Object)StarcBands$Values.MA, "ind2");
        runtimeDescriptor.declareIndicator((Object)StarcBands$Values.ST_BOTT, d);
        runtimeDescriptor.setRangeKeys(new Object[]{StarcBands$Values.ST_TOP, StarcBands$Values.ST_BOTT, StarcBands$Values.BB_TOP, StarcBands$Values.BB_BOTT});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(Math.max(Math.max(n2, n3), n4) + 1);
    }

    public void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3 + 1) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < n4 + 1) {
            return;
        }
        int n5 = this.getSettings().getInteger("period3");
        if (n2 < n5 + 1) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        double d2 = this.getSettings().getDouble(a);
        double d3 = this.getSettings().getDouble(b);
        Object object = this.getSettings().getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d4 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d4 == null) {
            return;
        }
        double d5 = dataSeries.atr(n2, n4);
        double d6 = d4 + (d5 *= d2);
        double d7 = d4 - d5;
        dataSeries.setDouble(n2, (Object)StarcBands$Values.MA, d4);
        dataSeries.setDouble(n2, (Object)StarcBands$Values.ST_TOP, Double.valueOf(d6));
        dataSeries.setDouble(n2, (Object)StarcBands$Values.ST_BOTT, Double.valueOf(d7));
        double[] dArray = n.a(dataSeries, n2, n5, d3, d3, object);
        dataSeries.setDouble(n2, (Object)StarcBands$Values.BB_TOP, Double.valueOf(dArray[0]));
        dataSeries.setDouble(n2, (Object)StarcBands$Values.BB_BOTT, Double.valueOf(dArray[1]));
        double d8 = dataSeries.getLow(n2);
        double d9 = dataSeries.getHigh(n2);
        double d10 = dataSeries.getDouble(n2 - 1, (Object)StarcBands$Values.MA, 0.0);
        boolean bl2 = d10 > d4 && d9 > dArray[0] && d9 > d6 && this.b;
        boolean bl3 = d10 < d4 && d8 < dArray[1] && d8 < d7 && this.a;
        dataSeries.setBoolean(n2, (Object)StarcBands$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)StarcBands$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = false;
            this.a = true;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d9);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_LOW_STARC_UPPER_BAND", new Object[]{Util.round((double)d9, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)StarcBands$Signals.SELL, string, (Object)d9);
        }
        if (bl3) {
            this.a = false;
            this.b = true;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d8);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_HIGH_STARC_LOWER_BAND", new Object[]{Util.round((double)d8, (int)2), Util.round((double)d7, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)StarcBands$Signals.BUY, string, (Object)d8);
        }
        dataSeries.setComplete(n2);
    }
}

