/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.overlay.ProBandUL$Signals;
import com.motivewave.platform.study.overlay.ProBandUL$Values;

@StudyHeader(namespace="com.motivewave", id="ID_PBUL", rb="com.motivewave.platform.study.nls.strings2", name="NAME_PROJECTION_BAND_UL", label="LBL_PBUL", desc="DESC_PBUL", helpLink="http://www.motivewave.com/studies/projection_band_ul.htm", signals=true, overlay=true, studyOverlay=true)
public class ProBandUL
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("TOP", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("BOTTOM", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("TOP", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("BOTTOM", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ProBandUL$Values.PL, this.get("PL", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ProBandUL$Values.PU, this.get("PU", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ProBandUL$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ProBandUL$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)ProBandUL$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)ProBandUL$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)ProBandUL$Values.PU, "line");
        runtimeDescriptor.declarePath((Object)ProBandUL$Values.PL, "line2");
        runtimeDescriptor.declareIndicator((Object)ProBandUL$Values.PU, "ind");
        runtimeDescriptor.declareIndicator((Object)ProBandUL$Values.PL, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{ProBandUL$Values.PU, ProBandUL$Values.PL});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        int n4 = 0;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        double d4 = n.a(dataSeries, n2, n3, Enums.BarInput.HIGH, 0)[1];
        double d5 = n.a(dataSeries, n2, n3, Enums.BarInput.LOW, 0)[1];
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            double d6 = dataSeries.getDouble(i2 - 1, (Object)Enums.BarInput.HIGH, 0.0);
            double d7 = dataSeries.getDouble(i2 - 1, (Object)Enums.BarInput.LOW, 0.0);
            double d8 = d6 + d4 * (double)n4;
            double d9 = d7 + d5 * (double)n4;
            if (d8 > d2) {
                d2 = d8;
            }
            if (d9 < d3) {
                d3 = d9;
            }
            ++n4;
        }
        dataSeries.setDouble(n2, (Object)ProBandUL$Values.PL, Double.valueOf(d3));
        dataSeries.setDouble(n2, (Object)ProBandUL$Values.PU, Double.valueOf(d2));
        double d10 = dataSeries.getHigh(n2);
        double d11 = dataSeries.getLow(n2);
        boolean bl2 = d10 > d2;
        boolean bl3 = d11 < d3;
        dataSeries.setBoolean(n2, (Object)ProBandUL$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)ProBandUL$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d10);
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PBUB_HIGH", new Object[]{d10});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ProBandUL$Signals.SELL, string, (Object)d10);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d11);
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PBLB_LOW", new Object[]{d11});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ProBandUL$Signals.BUY, string, (Object)d11);
        }
        dataSeries.setComplete(n2);
    }
}

