/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.PriceChannel$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="PRICE_CHANNEL", rb="com.motivewave.platform.study.nls.strings", name="TITLE_PRICE_CHANNEL", menu="MENU_OVERLAY", desc="DESC_PRICE_CHANNEL", label="LBL_PRICE_CHANNEL", overlay=true, helpLink="http://www.motivewave.com/studies/price_channel.htm")
public class PriceChannel
extends Study {
    static final String a = "topPeriod";
    static final String b = "bottomPeriod";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_TOP_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("LBL_BOTTOM_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("shift", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("topLine", this.get("LBL_TOP_LINE", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("bottomLine", this.get("LBL_BOTTOM_LINE", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("fill", this.get("LBL_FILL_COLOR", new Object[0]), "topLine", "bottomLine", Enums.ShadeType.BOTH, defaults.getFillColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("topInd", this.get("LBL_TOP_IND", new Object[0]), defaults.getBlue(), Color.WHITE, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("bottomInd", this.get("LBL_BOTTOM_IND", new Object[0]), defaults.getBlue(), Color.WHITE, false, false, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{a, b, "shift"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PriceChannel$Values.TOP, this.get("LBL_PRICE_CHANNEL_TOP", new Object[0]), new String[]{a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PriceChannel$Values.BOTTOM, this.get("LBL_PRICE_CHANNEL_BOTTOM", new Object[0]), new String[]{b}));
        runtimeDescriptor.declarePath((Object)PriceChannel$Values.TOP, "topLine");
        runtimeDescriptor.declarePath((Object)PriceChannel$Values.BOTTOM, "bottomLine");
        runtimeDescriptor.declareIndicator((Object)PriceChannel$Values.TOP, "topInd");
        runtimeDescriptor.declareIndicator((Object)PriceChannel$Values.BOTTOM, "bottomInd");
        runtimeDescriptor.setRangeKeys(new Object[]{PriceChannel$Values.TOP, PriceChannel$Values.BOTTOM});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public int getMinBars() {
        int n2 = this.getSettings().getInteger("shift", 0);
        int n3 = this.getSettings().getInteger(a);
        int n4 = this.getSettings().getInteger(b);
        return Math.max(n3, n4) + (n2 > 0 ? n2 : 0);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger(a);
        int n4 = this.getSettings().getInteger(b);
        int n5 = this.getSettings().getInteger("shift", 0);
        DataSeries dataSeries = dataContext.getDataSeries();
        if (n2 < n3 || n2 < n4) {
            return;
        }
        dataSeries.setDouble(n2 + n5, (Object)PriceChannel$Values.TOP, dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH));
        dataSeries.setDouble(n2 + n5, (Object)PriceChannel$Values.BOTTOM, dataSeries.lowest(n2, n4, (Object)Enums.BarInput.LOW));
        dataSeries.setComplete(n2 + n5, n2 >= 0 && n2 < dataSeries.size() - 1);
    }
}

