/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BarSizeDescriptor;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.FontDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.PrevPeriodRange$Values;
import com.motivewave.platform.study.overlay.m;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="PREV_PERIOD_RANGE", rb="com.motivewave.platform.study.nls.strings", name="TITLE_PREV_PERIOD_RANGE", label="LBL_PREV_PERIOD_RANGE", desc="DESC_PREV_PERIOD_RANGE", menu="MENU_OVERLAY", overlay=true, supportsBarUpdates=false, helpLink="http://www.motivewave.com/studies/previous_period_range.htm")
public class PrevPeriodRange
extends Study {
    static final String a = "range";
    static final String b = "showAll";
    static final String c = "extendRight";
    static final String d = "labels";
    static final String e = "highInd";
    static final String f = "lowInd";
    static final String g = "midInd";
    protected Map a = Collections.synchronizedMap(new HashMap());

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new BarSizeDescriptor("barSize", this.get("LBL_TIMEFRAME", new Object[0]), BarSize.getBarSize((Enums.BarSizeType)Enums.BarSizeType.LINEAR, (int)1440))});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("LBL_RANGE_PER", new Object[0]), 100.0, 0.1, 999.0, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(b, this.get("LBL_SHOW_ALL", new Object[0]), Boolean.valueOf(false))});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(c, this.get("LBL_EXTEND_RIGHT", new Object[0]), Boolean.valueOf(true))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("topLine", this.get("LBL_TOP_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("middleLine", this.get("LBL_MIDDLE_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, false, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("bottomLine", this.get("LBL_BOTTOM_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("fill", this.get("LBL_FILL", new Object[0]), defaults.getFillColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new FontDescriptor(d, this.get("LBL_LABELS", new Object[0]), defaults.getFont(), defaults.getTextColor(), true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(e, this.get("LBL_HIGH_IND", new Object[0]), defaults.getBlue(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("LBL_MID_IND", new Object[0]), defaults.getGreen(), null, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("LBL_LOW_IND", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"barSize", a});
        runtimeDescriptor.declareIndicator((Object)PrevPeriodRange$Values.HIGH, e);
        runtimeDescriptor.declareIndicator((Object)PrevPeriodRange$Values.LOW, f);
        runtimeDescriptor.declareIndicator((Object)PrevPeriodRange$Values.MID, g);
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void clearState() {
        super.clearState();
        this.a.clear();
    }

    public void onBarClose(DataContext dataContext) {
        this.calculateValues(dataContext);
    }

    protected void calculateValues(DataContext dataContext) {
        BarSize barSize = this.getSettings().getBarSize("barSize");
        DataSeries dataSeries = dataContext.getDataSeries(barSize);
        if (dataSeries.size() < 2) {
            return;
        }
        boolean bl2 = this.getSettings().getBoolean(b, false);
        boolean bl3 = this.getSettings().getBoolean(c, false);
        int n2 = 1;
        if (!bl2) {
            n2 = dataSeries.size() - 1;
            this.a.clear();
            this.clearFigures();
        }
        Instrument instrument = dataSeries.getInstrument();
        double d2 = this.getSettings().getDouble(a);
        d2 = Util.round((double)(d2 / 100.0), (int)3);
        for (int i2 = n2; i2 < dataSeries.size(); ++i2) {
            long l2 = dataSeries.getStartTime(i2);
            if (barSize.isLinear() && barSize.getIntervalMinutes() >= 1440) {
                l2 = instrument.getStartOfDay(l2, dataContext.isRTH());
            }
            if (this.a.containsKey(l2)) continue;
            double d3 = dataSeries.getHigh(i2 - 1);
            double d4 = dataSeries.getLow(i2 - 1);
            double d5 = d3 - d4;
            double d6 = d3;
            double d7 = d4;
            if (d2 > 1.0) {
                d6 += (d2 - 1.0) / 2.0 * d5;
                d7 -= (d2 - 1.0) / 2.0 * d5;
            } else if (d2 < 1.0) {
                d6 -= (1.0 - d2) / 2.0 * d5;
                d7 += (1.0 - d2) / 2.0 * d5;
            }
            long l3 = dataSeries.getEndTime(i2);
            if (barSize.isLinear() && barSize.getIntervalMinutes() >= 1440) {
                l3 = instrument.getEndOfDay(l2, dataContext.isRTH());
            }
            m m2 = new m(l2, l3, d6, d7);
            m2.a(bl3 && i2 == dataSeries.size() - 1);
            this.a.put(l2, m2);
            this.addFigure(m2);
        }
        m m3 = null;
        for (m m4 : this.a.values()) {
            if (m3 == null) {
                m3 = m4;
                continue;
            }
            if (m4.a() <= m3.a()) continue;
            m3 = m4;
        }
        if (m3 == null) {
            return;
        }
        DataSeries dataSeries2 = dataContext.getDataSeries();
        dataSeries2.setDouble((Object)PrevPeriodRange$Values.HIGH, Double.valueOf(m3.a()));
        dataSeries2.setDouble((Object)PrevPeriodRange$Values.LOW, Double.valueOf(m3.b()));
        dataSeries2.setDouble((Object)PrevPeriodRange$Values.MID, Double.valueOf(m3.c()));
    }
}

