/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.NVP;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BarSizeDescriptor;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.DiscreteDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.FontDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.PivotPoints$Values;
import com.motivewave.platform.study.overlay.h;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="PIVOT_POINTS", rb="com.motivewave.platform.study.nls.strings", name="TITLE_PIVOT_POINTS", desc="DESC_PIVOT_POINTS", menu="MENU_OVERLAY", overlay=true, helpLink="http://www.motivewave.com/studies/pivot_points.htm")
public class PivotPoints
extends Study {
    static final String a = "resistInd";
    static final String b = "pivotInd";
    static final String c = "supportInd";
    protected Map a = Collections.synchronizedMap(new HashMap());

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new BarSizeDescriptor("barSize", this.get("LBL_TIMEFRAME", new Object[0]), BarSize.getBarSize((Enums.BarSizeType)Enums.BarSizeType.LINEAR, (int)1440))});
        ArrayList<NVP> arrayList = new ArrayList<NVP>();
        arrayList.add(new NVP(this.get("LBL_CLASSIC", new Object[0]), "Classic"));
        arrayList.add(new NVP(this.get("LBL_WOODIE", new Object[0]), "Woodie"));
        arrayList.add(new NVP(this.get("LBL_CAMARILLA", new Object[0]), "Camarilla"));
        arrayList.add(new NVP(this.get("LBL_FIBONACCI", new Object[0]), "Fibonacci"));
        arrayList.add(new NVP(this.get("LBL_FIB_ZONE", new Object[0]), "Fib Zone"));
        arrayList.add(new NVP(this.get("LBL_FIB_ZONE2", new Object[0]), "FibZone2"));
        settingGroup.addRow(new SettingDescriptor[]{new DiscreteDescriptor("pivotType", this.get("LBL_PIVOT_TYPE", new Object[0]), "Classic", arrayList)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor("showAllPivots", this.get("LBL_SHOW_ALL_PIVOTS", new Object[0]), Boolean.valueOf(false)), new BooleanDescriptor("extendRight", this.get("LBL_EXTEND_RIGHT", new Object[0]), Boolean.valueOf(false))});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor("showLabels", this.get("LBL_SHOW_PIVOT_LABELS", new Object[0]), Boolean.valueOf(true)), new BooleanDescriptor("showPrices", this.get("LBL_SHOW_PIVOT_PRICES", new Object[0]), Boolean.valueOf(false))});
        settingTab.addGroup(settingGroup);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_RESISTANCE_LINE", new Object[0]), defaults.getGreenLine(), 2.0f, null, true, false, false, true);
        pathDescriptor.setSupportsShadeType(false);
        pathDescriptor.setSupportsColorPolicy(false);
        pathDescriptor.setSupportsShowPoints(false);
        pathDescriptor.setSupportsShowAsBars(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        pathDescriptor = new PathDescriptor("line2", this.get("LBL_PIVOT_LINE", new Object[0]), defaults.getLineColor(), 2.0f, null, true, false, false, true);
        pathDescriptor.setSupportsShadeType(false);
        pathDescriptor.setSupportsColorPolicy(false);
        pathDescriptor.setSupportsShowPoints(false);
        pathDescriptor.setSupportsShowAsBars(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        pathDescriptor = new PathDescriptor("line3", this.get("LBL_SUPPORT_LINE", new Object[0]), defaults.getRedLine(), 2.0f, null, true, false, false, true);
        pathDescriptor.setSupportsShadeType(false);
        pathDescriptor.setSupportsColorPolicy(false);
        pathDescriptor.setSupportsShowPoints(false);
        pathDescriptor.setSupportsShowAsBars(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        pathDescriptor = new PathDescriptor("line4", this.get("LBL_MIDDLE_LINES", new Object[0]), defaults.getGrey(), 1.0f, null, false, false, false, true);
        pathDescriptor.setSupportsColorPolicy(false);
        pathDescriptor.setSupportsShadeType(false);
        pathDescriptor.setSupportsShowPoints(false);
        pathDescriptor.setSupportsShowAsBars(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new FontDescriptor("font", this.get("LBL_FONT", new Object[0]), new Font("Arial", 1, 12))});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("LBL_RESIST_IND", new Object[0]), defaults.getGreen(), null, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("LBL_PIVOT_IND", new Object[0]), null, null, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(c, this.get("LBL_SUPPORT_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        settingTab.addGroup(settingGroup2);
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency("showLabels", new String[]{"showPrices"}));
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"barSize", "pivotType"});
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.P, b);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R1, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R2, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R3, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R4, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R5, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R6, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R7, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R8, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S1, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S2, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S3, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S4, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S5, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S6, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S7, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S8, c);
        this.setRuntimeDescriptor(runtimeDescriptor);
        this.setMinBars(2);
    }

    public void clearState() {
        super.clearState();
        this.a.clear();
    }

    public void onBarClose(DataContext dataContext) {
        this.calculateValues(dataContext);
    }

    protected void calculateValues(DataContext dataContext) {
        BarSize barSize = this.getSettings().getBarSize("barSize");
        DataSeries dataSeries = dataContext.getDataSeries(barSize);
        if (dataSeries.size() < 2) {
            return;
        }
        boolean bl2 = this.getSettings().getBoolean("showAllPivots", false);
        boolean bl3 = this.getSettings().getBoolean("extendRight", false);
        String string = this.getSettings().getString("pivotType", "Classic");
        int n2 = 0;
        if (!bl2) {
            n2 = dataSeries.size() - 1;
        }
        this.a.clear();
        this.clearFigures();
        Instrument instrument = dataSeries.getInstrument();
        for (int i2 = n2; i2 < dataSeries.size(); ++i2) {
            long l2 = dataSeries.getStartTime(i2);
            long l3 = dataSeries.getEndTime(i2);
            if (barSize.isLinear() && barSize.getIntervalMinutes() >= 1440) {
                l2 = instrument.getStartOfDay(l2 + 21600000L, dataContext.isRTH());
                if (dataContext.isRTH() && l2 < dataSeries.getStartTime(i2) - 21600000L) {
                    l2 += 86400000L;
                }
                l3 = l2 + barSize.getSizeMillis();
            }
            if (this.a.containsKey(l2)) continue;
            double d2 = dataSeries.getHigh(i2 - 1);
            double d3 = dataSeries.getLow(i2 - 1);
            double d4 = dataSeries.getClose(i2 - 1);
            double d5 = dataSeries.getOpen(i2 - 1);
            double d6 = (d2 + d3 + d4) / 3.0;
            double d7 = d2 - d3;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            double d17 = 0.0;
            double d18 = 0.0;
            double d19 = 0.0;
            double d20 = 0.0;
            double d21 = 0.0;
            double d22 = 0.0;
            double d23 = 0.0;
            h h2 = null;
            if (Util.compare((Object)string, (Object)"Woodie")) {
                d6 = (d2 + d3 + d4 + d5) / 4.0;
                d8 = 2.0 * d6 - d3;
                d9 = d6 + d7;
                d10 = d2 + 2.0 * (d6 - d3);
                d11 = d10 + d7;
                d16 = 2.0 * d6 - d2;
                d17 = d6 - d7;
                d18 = d3 - 2.0 * (d2 - d6);
                d19 = d18 - d7;
                h2 = new h(l2, l3, d6, d8, d9, d10, d11, d16, d17, d18, d19);
            } else if (Util.compare((Object)string, (Object)"Camarilla")) {
                d11 = d4 + d7 * 1.1 / 2.0;
                d10 = d4 + d7 * 1.1 / 4.0;
                d9 = d4 + d7 * 1.1 / 6.0;
                d8 = d4 + d7 * 1.1 / 12.0;
                d16 = d4 - d7 * 1.1 / 12.0;
                d17 = d4 - d7 * 1.1 / 6.0;
                d18 = d4 - d7 * 1.1 / 4.0;
                d19 = d4 - d7 * 1.1 / 2.0;
                h2 = new h(l2, l3, d4, d8, d9, d10, d11, d16, d17, d18, d19);
            } else if (Util.compare((Object)string, (Object)"Fibonacci")) {
                d11 = d6 + 1.618 * d7;
                d10 = d6 + 1.0 * d7;
                d9 = d6 + 0.618 * d7;
                d8 = d6 + 0.382 * d7;
                d16 = d6 - 0.382 * d7;
                d17 = d6 - 0.618 * d7;
                d18 = d6 - 1.0 * d7;
                d19 = d6 - 1.618 * d7;
                h2 = new h(l2, l3, d6, d8, d9, d10, d11, d16, d17, d18, d19);
                h2.m = "+0.382";
                h2.n = "+0.618";
                h2.o = "+1.00";
                h2.p = "+1.618";
                h2.l = "BP";
                h2.u = "-0.382";
                h2.v = "-0.618";
                h2.w = "-1.00";
                h2.x = "-1.618";
            } else if (Util.compare((Object)string, (Object)"Fib Zone")) {
                d11 = d6 + 1.382 * d7;
                d10 = d6 + d7;
                d9 = d6 + 0.618 * d7;
                d8 = d6 + 0.5 * d7;
                d16 = d6 - 0.5 * d7;
                d17 = d6 - 0.618 * d7;
                d18 = d6 - d7;
                d19 = d6 - 1.382 * d7;
                h2 = new h(l2, l3, d6, d8, d9, d10, d11, d16, d17, d18, d19);
                h2.a(d11, d10);
                h2.a(d9, d8);
                h2.a(d16, d17);
                h2.a(d18, d19);
                h2.m = "+0.5";
                h2.n = "+0.618";
                h2.o = "+1.00";
                h2.p = "+1.382";
                h2.l = "BP";
                h2.u = "-0.5";
                h2.v = "-0.618";
                h2.w = "-1.00";
                h2.x = "-1.382";
            } else if (Util.compare((Object)string, (Object)"FibZone2")) {
                d15 = d6 + 2.618 * d7;
                d14 = d6 + 1.618 * d7;
                d13 = d6 + 1.27 * d7;
                d12 = d6 + 1.13 * d7;
                d11 = d6 + 0.886 * d7;
                d10 = d6 + 0.786 * d7;
                d9 = d6 + 0.618 * d7;
                d8 = d6 + 0.382 * d7;
                d16 = d6 - 0.382 * d7;
                d17 = d6 - 0.618 * d7;
                d18 = d6 - 0.786 * d7;
                d19 = d6 - 0.886 * d7;
                d20 = d6 - 1.13 * d7;
                d21 = d6 - 1.27 * d7;
                d22 = d6 - 1.618 * d7;
                d23 = d6 - 2.618 * d7;
                h2 = new h(l2, l3, d6, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17, d18, d19, d20, d21, d22, d23);
                h2.a(d14, d15);
                h2.a(d12, d13);
                h2.a(d11, d10);
                h2.a(d9, d8);
                h2.a(d16, d17);
                h2.a(d18, d19);
                h2.a(d20, d21);
                h2.a(d22, d23);
                h2.m = "+0.382";
                h2.n = "+0.618";
                h2.o = "+0.786";
                h2.p = "+0.886";
                h2.q = "+1.13";
                h2.r = "+1.27";
                h2.s = "+1.618";
                h2.t = "+2.618";
                h2.l = "BP";
                h2.u = "-0.382";
                h2.v = "-0.618";
                h2.w = "-0.786";
                h2.x = "-0.886";
                h2.y = "-1.13";
                h2.z = "-1.27";
                h2.A = "-1.618";
                h2.B = "-2.618";
            } else {
                d8 = d6 * 2.0 - d3;
                d16 = d6 * 2.0 - d2;
                d9 = d6 - d16 + d8;
                d17 = d6 - (d8 - d16);
                d10 = 2.0 * (d6 - d3) + d2;
                d18 = d3 - 2.0 * (d2 - d6);
                h2 = new h(l2, l3, d6, d8, d9, d10, d16, d17, d18);
            }
            h2.a(bl3 && i2 == dataSeries.size() - 1);
            this.a.put(l2, h2);
            this.addFigure(h2);
        }
        h h3 = null;
        for (h h4 : this.a.values()) {
            if (h3 == null) {
                h3 = h4;
                continue;
            }
            if (h4.a <= h3.a) continue;
            h3 = h4;
        }
        if (h3 != null) {
            DataSeries dataSeries2 = dataContext.getDataSeries();
            dataSeries2.setDouble((Object)PivotPoints$Values.P, h3.c() == 0.0 ? null : Double.valueOf(h3.c()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R1, h3.d() == 0.0 ? null : Double.valueOf(h3.d()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R2, h3.e() == 0.0 ? null : Double.valueOf(h3.e()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R3, h3.f() == 0.0 ? null : Double.valueOf(h3.f()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R4, h3.g() == 0.0 ? null : Double.valueOf(h3.g()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R5, h3.h() == 0.0 ? null : Double.valueOf(h3.h()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R6, h3.i() == 0.0 ? null : Double.valueOf(h3.i()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R7, h3.j() == 0.0 ? null : Double.valueOf(h3.j()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R8, h3.k() == 0.0 ? null : Double.valueOf(h3.k()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S1, h3.l() == 0.0 ? null : Double.valueOf(h3.l()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S2, h3.m() == 0.0 ? null : Double.valueOf(h3.m()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S3, h3.n() == 0.0 ? null : Double.valueOf(h3.n()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S4, h3.o() == 0.0 ? null : Double.valueOf(h3.o()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S5, h3.p() == 0.0 ? null : Double.valueOf(h3.p()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S6, h3.q() == 0.0 ? null : Double.valueOf(h3.q()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S7, h3.r() == 0.0 ? null : Double.valueOf(h3.r()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S8, h3.s() == 0.0 ? null : Double.valueOf(h3.s()));
        }
    }
}

